/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.aggregation;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.gui.plotter.SimplePlotterDialog;
import edu.udo.cs.yale.operator.features.aggregation.AggregationIndividual;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationPopulationPlotter
implements ObjectVisualizer {
    private ExampleSet originalExampleSet;
    private Attribute[] allAttributes;
    private FeatureGenerator generator;
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;
    private List<AggregationIndividual> lastPopulation;

    public AggregationPopulationPlotter(ExampleSet originalExampleSet, Attribute[] allAttributes, FeatureGenerator generator) {
        this.originalExampleSet = originalExampleSet;
        this.allAttributes = allAttributes;
        this.generator = generator;
    }

    public void operate(List<AggregationIndividual> pop) {
        if (pop.size() == 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = this.createDataTable(pop);
        }
        int numberOfCriteria = this.fillDataTable(this.criteriaDataTable, pop);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(this.criteriaDataTable, false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setDraw2DLines(false);
            this.plotter.setVisible(true);
            this.plotter.addObjectVisualizer(this);
        }
        this.lastPopulation = pop;
    }

    public SimpleDataTable createDataTable(List<AggregationIndividual> pop) {
        PerformanceVector prototype = pop.get(0).getPerformance();
        SimpleDataTable dataTable = new SimpleDataTable("Population", prototype.getCriteriaNames());
        return dataTable;
    }

    public int fillDataTable(SimpleDataTable dataTable, List<AggregationIndividual> pop) {
        dataTable.clear();
        int numberOfCriteria = 0;
        int i = 0;
        while (i < pop.size()) {
            String id = String.valueOf(i) + " (";
            PerformanceVector current = pop.get(i).getPerformance();
            numberOfCriteria = Math.max(numberOfCriteria, current.getSize());
            double[] data = new double[current.getSize()];
            int d = 0;
            while (d < data.length) {
                data[d] = current.getCriterion(d).getFitness();
                if (d != 0) {
                    id = String.valueOf(id) + ", ";
                }
                id = String.valueOf(id) + Tools.formatNumber(data[d]);
                ++d;
            }
            id = String.valueOf(id) + ")";
            dataTable.add(new SimpleDataTableRow(data, id));
            ++i;
        }
        return numberOfCriteria;
    }

    @Override
    public boolean isCapableToVisualize(String id) {
        int index = Integer.parseInt(id.substring(0, id.indexOf("(")).trim());
        return index >= 0 && index < this.lastPopulation.size();
    }

    @Override
    public String getTitle(String id) {
        return id;
    }

    @Override
    public void stopVisualization(String id) {
    }

    @Override
    public void startVisualization(String id) {
        int index = Integer.parseInt(id.substring(0, id.indexOf("(")).trim());
        AggregationIndividual individual = this.lastPopulation.get(index);
        ExampleSet es = null;
        try {
            es = individual.createExampleSet(this.originalExampleSet, this.allAttributes, this.generator);
        }
        catch (GenerationException e) {
            throw new RuntimeException("Cannot visualize individual '" + index + "': " + e.getMessage());
        }
        Component visualizationComponent = es.getVisualizationComponent(null);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JScrollPane(visualizationComponent), "Center");
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

