/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.aggregation;

import edu.udo.cs.yale.operator.features.aggregation.AggregationIndividual;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationMutation {
    private RandomGenerator random;

    public AggregationMutation(RandomGenerator random) {
        this.random = random;
    }

    private boolean isValid(int[] individual) {
        int i = 0;
        while (i < individual.length) {
            if (individual[i] >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void mutate(List<AggregationIndividual> population) {
        ArrayList<AggregationIndividual> children = new ArrayList<AggregationIndividual>();
        for (AggregationIndividual individual : population) {
            int[] parent = individual.getIndividual();
            int[] child = new int[parent.length];
            int j = 0;
            while (j < child.length) {
                child[j] = parent[j];
                ++j;
            }
            this.mutate(child);
            if (!this.isValid(child)) continue;
            children.add(new AggregationIndividual(child));
        }
        population.addAll(children);
    }

    private void mutate(int[] individual) {
        double prob = 1.0 / (double)individual.length;
        int max = -1;
        int i = 0;
        while (i < individual.length) {
            if (individual[i] > max) {
                max = individual[i];
            }
            ++i;
        }
        i = 0;
        while (i < individual.length) {
            if (this.random.nextDouble() < prob) {
                individual[i] = this.random.nextIntInRange(-1, max + 1);
            }
            ++i;
        }
    }
}

