/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.aggregation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationIndividual {
    private int[] individual;
    private PerformanceVector fitness = null;
    private double crowdingDistance;

    public AggregationIndividual(int[] individual) {
        this.individual = individual;
    }

    public double getCrowdingDistance() {
        return this.crowdingDistance;
    }

    public void setCrowdingDistance(double crowdingDistance) {
        this.crowdingDistance = crowdingDistance;
    }

    public int[] getIndividual() {
        return this.individual;
    }

    public void setPerformance(PerformanceVector fitness) {
        this.fitness = fitness;
    }

    public PerformanceVector getPerformance() {
        return this.fitness;
    }

    public ExampleSet createExampleSet(ExampleSet originalExampleSet, Attribute[] allAttributes, FeatureGenerator generator) throws GenerationException {
        List<String> mergeList;
        AttributeWeightedExampleSet es = new AttributeWeightedExampleSet((ExampleSet)originalExampleSet.clone());
        HashMap<Integer, LinkedList<String>> mergeMap = new HashMap<Integer, LinkedList<String>>();
        int i = 0;
        while (i < this.individual.length) {
            if (this.individual[i] == 0) {
                es.setWeight(allAttributes[i], 1.0);
            } else {
                es.setWeight(allAttributes[i], 0.0);
                if (this.individual[i] > 0) {
                    mergeList = (List)mergeMap.get(this.individual[i]);
                    if (mergeList != null) {
                        mergeList.add(allAttributes[i].getName());
                    } else {
                        mergeList = new LinkedList<String>();
                        mergeList.add(allAttributes[i].getName());
                        mergeMap.put(this.individual[i], (LinkedList<String>)mergeList);
                    }
                }
            }
            ++i;
        }
        Iterator i2 = mergeMap.keySet().iterator();
        while (i2.hasNext()) {
            mergeList = (LinkedList<String>)mergeMap.get(i2.next());
            if (mergeList.size() == 1) {
                es.setWeight(es.getAttributes().getRegular((String)mergeList.get(0)), 1.0);
                continue;
            }
            if (mergeList.size() <= 1) continue;
            this.addNewMergedAttribute(es, mergeList, generator);
        }
        AttributeWeightedExampleSet result = es.createCleanClone();
        return result;
    }

    private void addNewMergedAttribute(AttributeWeightedExampleSet es, List<String> mergeList, FeatureGenerator generator) throws GenerationException {
        Attribute mergeAttribute = null;
        Iterator<String> i = mergeList.iterator();
        while (i.hasNext()) {
            Attribute currentAttribute = es.getAttributes().getRegular(i.next());
            if (mergeAttribute == null) {
                mergeAttribute = currentAttribute;
                continue;
            }
            generator = generator.newInstance();
            Attribute[] args = new Attribute[]{mergeAttribute, currentAttribute};
            generator.setArguments(args);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> newAttributes = FeatureGenerator.generateAll(es.getExampleTable(), generatorList);
            mergeAttribute = newAttributes.get(0);
        }
        es.getAttributes().addRegular(mergeAttribute);
    }
}

