/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.aggregation;

import edu.udo.cs.yale.operator.features.aggregation.AggregationIndividual;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationCrossover {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform"};
    public static final int CROSSOVER_ONE_POINT = 0;
    public static final int CROSSOVER_UNIFORM = 1;
    private int crossoverType = 1;
    private double crossoverProb = 0.9;
    private Random random;

    public AggregationCrossover(int type, double probability, Random random) {
        this.crossoverType = type;
        this.crossoverProb = probability;
        this.random = random;
    }

    private boolean isValid(int[] individual) {
        int i = 0;
        while (i < individual.length) {
            if (individual[i] >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void crossover(List<AggregationIndividual> population) {
        ArrayList<AggregationIndividual> children = new ArrayList<AggregationIndividual>();
        int i = 0;
        while (i < population.size()) {
            if (this.random.nextDouble() < this.crossoverProb) {
                int[] parent1 = population.get(this.random.nextInt(population.size())).getIndividual();
                int[] parent2 = population.get(this.random.nextInt(population.size())).getIndividual();
                int[] child1 = new int[parent1.length];
                int j = 0;
                while (j < child1.length) {
                    child1[j] = parent1[j];
                    ++j;
                }
                int[] child2 = new int[parent2.length];
                int j2 = 0;
                while (j2 < child2.length) {
                    child2[j2] = parent2[j2];
                    ++j2;
                }
                this.crossover(child1, child2);
                if (this.isValid(child1)) {
                    children.add(new AggregationIndividual(child1));
                }
                if (this.isValid(child2)) {
                    children.add(new AggregationIndividual(child2));
                }
            }
            ++i;
        }
        population.addAll(children);
    }

    private void crossover(int[] individual1, int[] individual2) {
        switch (this.crossoverType) {
            case 0: {
                int n;
                int i = n = 1 + this.random.nextInt(individual1.length - 1);
                while (i < individual1.length) {
                    int dummy = individual1[i];
                    individual1[i] = individual2[i];
                    individual2[i] = dummy;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < individual1.length) {
                    if (this.random.nextBoolean()) {
                        int dummy = individual1[i];
                        individual1[i] = individual2[i];
                        individual2[i] = dummy;
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

