/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUselessAttributes
extends IndividualOperator {
    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        Iterator<Attribute> i = clone.getAttributes().iterator();
        while (i.hasNext()) {
            NumericalAttributeStatistics stats;
            Attribute attribute = i.next();
            double weight = clone.getWeight(attribute);
            if (weight == 0.0) {
                i.remove();
                continue;
            }
            if (attribute.isNominal() || (stats = (NumericalAttributeStatistics)attribute.getStatistics()).getMinimum() != stats.getMaximum() || stats.getMinimum() != 0.0 && stats.getMinimum() != 1.0) continue;
            i.remove();
        }
        LinkedList<Individual> l = new LinkedList<Individual>();
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(new Individual(clone));
        } else {
            LogService.logMessage("No attributes left after removing useless attributes! Using original example set.", 4);
            l.add(new Individual(exampleSet));
        }
        return l;
    }
}

