/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.gui.plotter.SimplePlotterDialog;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.selection.NonDominatedSortingSelection;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class PopulationPlotter
implements PopulationOperator,
ObjectVisualizer {
    private int plotGenerations = 1;
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;
    private boolean setDrawRange = false;
    private boolean drawDominated = true;
    private Population lastPopulation;

    public PopulationPlotter() {
        this(1, false, true);
    }

    public PopulationPlotter(int plotGenerations, boolean setDrawRange, boolean drawDominated) {
        this.plotGenerations = plotGenerations;
        this.setDrawRange = setDrawRange;
        this.drawDominated = drawDominated;
    }

    public boolean performOperation(int generation) {
        return generation % this.plotGenerations == 0;
    }

    public void operate(Population pop) {
        if (pop.getNumberOfIndividuals() == 0) {
            return;
        }
        if (pop.getGeneration() % this.plotGenerations != 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = PopulationPlotter.createDataTable(pop);
        }
        int numberOfCriteria = PopulationPlotter.fillDataTable(this.criteriaDataTable, pop, this.drawDominated);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(this.criteriaDataTable, false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setDraw2DLines(false);
            this.plotter.setVisible(true);
            this.plotter.addObjectVisualizer(this);
        }
        if (this.setDrawRange) {
            this.plotter.setDrawRange(0.0, 1.0, 0.0, 1.0);
        }
        this.plotter.setKey("Generation " + pop.getGeneration());
        this.lastPopulation = pop;
    }

    public static SimpleDataTable createDataTable(Population pop) {
        PerformanceVector prototype = pop.get(0).getPerformance();
        SimpleDataTable dataTable = new SimpleDataTable("Population", prototype.getCriteriaNames());
        return dataTable;
    }

    public static int fillDataTable(SimpleDataTable dataTable, Population pop, boolean drawDominated) {
        dataTable.clear();
        int numberOfCriteria = 0;
        int i = 0;
        while (i < pop.getNumberOfIndividuals()) {
            boolean dominated = false;
            if (!drawDominated) {
                int j = 0;
                while (j < pop.getNumberOfIndividuals()) {
                    if (i != j && NonDominatedSortingSelection.isDominated(pop.get(i), pop.get(j))) {
                        dominated = true;
                        break;
                    }
                    ++j;
                }
            }
            if (drawDominated || !dominated) {
                String id = String.valueOf(i) + " (";
                PerformanceVector current = pop.get(i).getPerformance();
                numberOfCriteria = Math.max(numberOfCriteria, current.getSize());
                double[] data = new double[current.getSize()];
                int d = 0;
                while (d < data.length) {
                    data[d] = current.getCriterion(d).getFitness();
                    if (d != 0) {
                        id = String.valueOf(id) + ", ";
                    }
                    id = String.valueOf(id) + Tools.formatNumber(data[d]);
                    ++d;
                }
                id = String.valueOf(id) + ")";
                dataTable.add(new SimpleDataTableRow(data, id));
            }
            ++i;
        }
        return numberOfCriteria;
    }

    public boolean isCapableToVisualize(String id) {
        int index = Integer.parseInt(id.substring(0, id.indexOf("(")).trim());
        return index >= 0 && index < this.lastPopulation.getNumberOfIndividuals();
    }

    public String getTitle(String id) {
        return id;
    }

    public void stopVisualization(String id) {
    }

    public void startVisualization(String id) {
        int index = Integer.parseInt(id.substring(0, id.indexOf("(")).trim());
        AttributeWeightedExampleSet es = this.lastPopulation.get(index).getExampleSet().createCleanClone();
        Component visualizationComponent = es.getVisualizationComponent(null);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JScrollPane(visualizationComponent), "Center");
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

