/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.dialog.IndividualSelector;
import edu.udo.cs.yale.gui.dialog.StopDialog;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.PopulationPlotter;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureOperator
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private Population population;
    private double maximalFitness = Double.POSITIVE_INFINITY;
    private boolean checkForMaximalFitness = true;
    private int evaluationCounter = 0;
    private int totalEvaluations = 0;
    private RandomGenerator random;

    public FeatureOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("generation", "The number of the current generation."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return 0.0;
                }
                return FeatureOperator.this.population.getGeneration();
            }
        });
        this.addValue(new Value("performance", "The performance of the current generation (main criterion)."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                if (FeatureOperator.this.population.getCurrentBestPerformance() == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = FeatureOperator.this.population.getCurrentBestPerformance();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new Value("best", "The performance of the best individual ever (main criterion)."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = FeatureOperator.this.population.getBestPerformanceEver();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new Value("average_length", "The average number of attributes."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                double lengthSum = 0.0;
                int i = 0;
                while (i < FeatureOperator.this.population.getNumberOfIndividuals()) {
                    lengthSum += (double)FeatureOperator.this.population.get(i).getExampleSet().getNumberOfUsedAttributes();
                    ++i;
                }
                return lengthSum / (double)FeatureOperator.this.population.getNumberOfIndividuals();
            }
        });
        this.addValue(new Value("best_length", "The number of attributes of the best example set."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                AttributeWeightedExampleSet eSet = FeatureOperator.this.population.getBestIndividualEver().getExampleSet();
                if (eSet != null) {
                    return eSet.getNumberOfUsedAttributes();
                }
                return Double.NaN;
            }
        });
    }

    public abstract Population createInitialPopulation(ExampleSet var1) throws OperatorException;

    public abstract List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract boolean solutionGoodEnough(Population var1) throws OperatorException;

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    protected RandomGenerator getRandom() {
        return this.random;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        this.evaluationCounter = 0;
        this.totalEvaluations = 0;
        this.maximalFitness = this.getParameterAsDouble("maximal_fitness");
        ExampleSet es = this.getInput(ExampleSet.class);
        List<PopulationOperator> preOps = this.getPreEvaluationPopulationOperators(es);
        List<PopulationOperator> postOps = this.getPostEvaluationPopulationOperators(es);
        boolean userDialogOk = true;
        StopDialog stopDialog = null;
        if (this.getParameterAsBoolean("show_stop_dialog")) {
            stopDialog = new StopDialog("Stop Dialog", "<html>Press the stop button to abort the search for best feature space.<br>The best individual found so far is returned.</html>");
            stopDialog.setVisible(true);
        }
        this.population = this.createInitialPopulation((ExampleSet)es.clone());
        LogService.logMessage(String.valueOf(this.getName()) + ": initial population has " + this.population.getNumberOfIndividuals() + " individuals.", 2);
        this.evaluate(this.population);
        PopulationPlotter popPlotter = null;
        this.population.updateEvaluation();
        if (this.getParameterAsBoolean("show_population_plotter")) {
            popPlotter = new PopulationPlotter(this.getParameterAsInt("plot_generations"), this.getParameterAsBoolean("constraint_draw_range"), this.getParameterAsBoolean("draw_dominated_points"));
            popPlotter.operate(this.population);
        }
        this.inApplyLoop();
        while (userDialogOk && !this.solutionGoodEnough(this.population) && !this.isMaximumReached()) {
            this.population.nextGeneration();
            this.applyOpList(preOps, this.population);
            LogService.logMessage(String.valueOf(Tools.ordinalNumber(this.population.getGeneration())) + " generation has " + this.population.getNumberOfIndividuals() + " individuals.", 2);
            LogService.logMessage(String.valueOf(this.getName()) + ": evaluating " + Tools.ordinalNumber(this.population.getGeneration()) + " population.", 2);
            this.evaluate(this.population);
            this.population.updateEvaluation();
            this.applyOpList(postOps, this.population);
            if (popPlotter != null) {
                popPlotter.operate(this.population);
            }
            userDialogOk = stopDialog == null ? true : stopDialog.isStillRunning();
            this.inApplyLoop();
        }
        if (stopDialog != null) {
            stopDialog.setVisible(false);
            stopDialog.dispose();
        }
        this.applyOpList(postOps, this.population);
        LogService.logMessage(String.valueOf(this.getName()) + ": optimization finished. " + this.evaluationCounter + " / " + this.totalEvaluations + " evaluations performed.", 2);
        if (this.isParameterSet("population_criteria_data_file")) {
            File outFile = this.getParameterAsFile("population_criteria_data_file");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(outFile));
                SimpleDataTable finalStatistics = PopulationPlotter.createDataTable(this.population);
                PopulationPlotter.fillDataTable(finalStatistics, this.population, this.getParameterAsBoolean("draw_dominated_points"));
                finalStatistics.write(out);
                out.close();
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{outFile, e.getMessage()});
            }
        }
        Individual bestEver = null;
        if (this.getParameterAsBoolean("user_result_individual_selection")) {
            IndividualSelector selector = new IndividualSelector(this.population);
            selector.setVisible(true);
            bestEver = selector.getSelectedIndividual();
            if (bestEver == null) {
                LogService.logMessage("No individual selected. Using individual with highest fitness for main criterion...", 4);
            }
        }
        if (bestEver == null) {
            bestEver = this.population.getBestIndividualEver();
        }
        AttributeWeightedExampleSet weightedResultSet = bestEver.getExampleSet();
        AttributeWeights weights = weightedResultSet.getAttributeWeights();
        for (String name : weights.getAttributeNames()) {
            if (weightedResultSet.getAttributes().get(name) != null) continue;
            weights.setWeight(name, 0.0);
        }
        return new IOObject[]{weightedResultSet.createCleanClone(), weights, this.population.getBestPerformanceEver()};
    }

    void applyOpList(List opList, Population population) throws OperatorException {
        Iterator i = opList.listIterator();
        while (i.hasNext()) {
            PopulationOperator op = (PopulationOperator)i.next();
            if (!op.performOperation(population.getGeneration())) continue;
            try {
                op.operate(population);
                int k = 0;
                while (k < population.getNumberOfIndividuals()) {
                    if (population.get(k).getExampleSet().getNumberOfUsedAttributes() <= 0) {
                        LogService.logMessage("Population operator " + op + " has produced an example set without attributes!", 6);
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                throw new UserError((Operator)this, (Throwable)e, 108, (Object)e.toString());
            }
        }
    }

    protected void evaluate(Population population) throws OperatorException {
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            this.evaluate(population.get(i));
            ++i;
        }
    }

    protected PerformanceVector evaluate(Individual individual) throws OperatorException {
        ++this.totalEvaluations;
        if (individual.getPerformance() != null) {
            return individual.getPerformance();
        }
        ++this.evaluationCounter;
        AttributeWeightedExampleSet clone = individual.getExampleSet().createCleanClone();
        IOObject[] operatorChainInput = new IOObject[]{clone};
        IOContainer innerResult = this.getInput().prepend(operatorChainInput);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            innerResult = this.getOperator(i).apply(innerResult);
            ++i;
        }
        PerformanceVector performanceVector = innerResult.remove(PerformanceVector.class);
        individual.setPerformance(performanceVector);
        return performanceVector;
    }

    private boolean isMaximumReached() {
        if (this.checkForMaximalFitness) {
            PerformanceVector pv = this.population.getBestPerformanceEver();
            if (pv == null) {
                return false;
            }
            if (pv.getMainCriterion().getFitness() == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (pv.getMainCriterion().getMaxFitness() == pv.getMainCriterion().getFitness()) {
                return true;
            }
            return pv.getMainCriterion().getFitness() >= this.maximalFitness;
        }
        return false;
    }

    protected void setCheckForMaximum(boolean checkForMaximalFitness) {
        this.checkForMaximalFitness = checkForMaximalFitness;
    }

    protected boolean getCheckForMaximum() {
        return this.checkForMaximalFitness;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        ParameterTypeBoolean type = new ParameterTypeBoolean("show_stop_dialog", "Determines if a dialog with a button should be displayed which stops the run: the best individual is returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("user_result_individual_selection", "Determines if the user wants to select the final result individual from the last population.", false));
        types.add(new ParameterTypeBoolean("show_population_plotter", "Determines if the current population should be displayed in performance space.", false));
        types.add(new ParameterTypeInt("plot_generations", "Update the population plotter in these generations.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean("constraint_draw_range", "Determines if the draw range of the population plotter should be constrained between 0 and 1.", false));
        types.add(new ParameterTypeBoolean("draw_dominated_points", "Determines if only points which are not Pareto dominated should be painted.", true));
        types.add(new ParameterTypeFile("population_criteria_data_file", "The path to the file in which the criteria data of the final population should be saved.", "cri", true));
        types.add(new ParameterTypeDouble("maximal_fitness", "The optimization will stop if the fitness reaches the defined maximum.", 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        return types;
    }
}

