/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.condition;

import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.WrongNumberOfInnerOperatorsException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.tools.Tools;

public class LastInnerOperatorCondition
implements InnerOperatorCondition {
    private Class[] mustDeliver;
    private Class[] willGet;

    public LastInnerOperatorCondition(Class[] mustDeliver) {
        this(null, mustDeliver);
    }

    public LastInnerOperatorCondition(Class[] willGet, Class[] mustDeliver) {
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
    }

    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMinNumberOfInnerOperators(), 0);
        }
        Class[] output = input;
        if (this.willGet != null) {
            output = new Class[input.length + this.willGet.length];
            System.arraycopy(input, 0, output, 0, input.length);
            System.arraycopy(this.willGet, 0, output, input.length, this.willGet.length);
        }
        int i = 0;
        while (i < chain.getNumberOfOperators()) {
            Operator operator = chain.getOperator(i);
            if (operator.isEnabled()) {
                output = operator.checkIO(output);
            }
            ++i;
        }
        i = 0;
        while (i < this.mustDeliver.length) {
            if (!IODescription.containsClass(this.mustDeliver[i], output)) {
                throw new IllegalInputException(chain, chain.getOperator(chain.getNumberOfOperators() - 1), this.mustDeliver[i]);
            }
            ++i;
        }
        return output;
    }

    public String toHTML() {
        StringBuffer result = new StringBuffer("The inner operators must deliver [");
        int i = 0;
        while (i < this.mustDeliver.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(Tools.classNameWOPackage(this.mustDeliver[i]));
            ++i;
        }
        result.append("].");
        return result.toString();
    }
}

