/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.condition;

import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.WrongNumberOfInnerOperatorsException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.tools.Tools;

public class AllInnerOperatorCondition
implements InnerOperatorCondition {
    private Class[] willGet;
    private Class[] mustDeliver;

    public AllInnerOperatorCondition(Class[] willGet, Class[] mustDeliver) {
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
    }

    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMinNumberOfInnerOperators(), 0);
        }
        Class[] innerOutput = input;
        int i = 0;
        while (i < chain.getNumberOfOperators()) {
            Operator operator = chain.getOperator(i);
            innerOutput = operator.checkIO(this.willGet);
            int j = 0;
            while (j < this.mustDeliver.length) {
                if (!IODescription.containsClass(this.mustDeliver[j], innerOutput)) {
                    throw new IllegalInputException(chain, operator, this.mustDeliver[j]);
                }
                ++j;
            }
            ++i;
        }
        return innerOutput;
    }

    public String toHTML() {
        StringBuffer result = new StringBuffer("Each inner operator must be able to handle [");
        int i = 0;
        while (i < this.willGet.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(Tools.classNameWOPackage(this.willGet[i]));
            ++i;
        }
        result.append("] and must deliver [");
        i = 0;
        while (i < this.mustDeliver.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(Tools.classNameWOPackage(this.mustDeliver[i]));
            ++i;
        }
        result.append("].");
        return result.toString();
    }
}

