/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.AbstractIOObject;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultObjectAdapter
extends AbstractIOObject
implements ResultObject,
Saveable {
    private transient List<Action> actions;

    public ResultObjectAdapter() {
        this.initActions();
    }

    private void initActions() {
        this.actions = new LinkedList<Action>();
        if (this.isSavable()) {
            this.addAction(new AbstractAction("Save..."){
                private static final long serialVersionUID = -5888181920926434464L;
                {
                    this.putValue("ShortDescription", "Save this " + Tools.classNameWOPackage(ResultObjectAdapter.this.getClass()) + " to disk.");
                }

                public void actionPerformed(ActionEvent e) {
                    File file = SwingTools.chooseFile(null, null, false, ResultObjectAdapter.this.getExtension(), ResultObjectAdapter.this.getFileDescription());
                    try {
                        if (file != null) {
                            ResultObjectAdapter.this.save(file);
                        }
                    }
                    catch (Exception ex) {
                        SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
                    }
                }
            });
        }
    }

    private Object readResolve() {
        this.initActions();
        return this;
    }

    @Override
    public String getName() {
        return Tools.classNameWOPackage(this.getClass());
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public void save(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.write(out);
        ((OutputStream)out).close();
    }

    protected void addAction(Action a) {
        this.actions.add(a);
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public String toResultString() {
        return this.toString();
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        String str = ResultObjectAdapter.toHTML(this.toResultString());
        JEditorPane resultText = new JEditorPane();
        resultText.setContentType("text/html");
        resultText.setText("<html><h1>" + this.getName() + "</h1><pre>" + str + "</pre></html>");
        resultText.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        resultText.setEditable(false);
        resultText.setBackground(new JLabel().getBackground());
        return new JScrollPane(resultText);
    }

    public static String toHTML(String string) {
        String str = string;
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(Tools.getLineSeparator(), "<br>");
        return str;
    }
}

