/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorDescription
implements Comparable<OperatorDescription> {
    private String name;
    private Class<?> clazz;
    private String description;
    private String group;
    private Image icon = null;
    private String iconPath;
    private String deprecationInfo = null;

    public OperatorDescription(ClassLoader classLoader, String name, String className, String description, String group, String icon, String deprecationInfo) throws ClassNotFoundException {
        this.name = name;
        this.clazz = Class.forName(className, true, classLoader);
        this.description = description;
        this.group = group;
        this.deprecationInfo = deprecationInfo;
        if (this.deprecationInfo != null && this.deprecationInfo.trim().length() == 0) {
            this.deprecationInfo = null;
        }
        URL url = null;
        if (icon != null && icon.length() > 0) {
            url = Tools.getResource("icons/operators/24/" + icon + ".png");
            this.iconPath = "/operators/24/" + icon + ".png";
        } else {
            String groupIconName = group.toLowerCase();
            url = Tools.getResource("icons/groups/24/" + groupIconName + ".png");
            while (url == null && groupIconName.length() > 0) {
                if (groupIconName.indexOf(".") >= 0) {
                    groupIconName = groupIconName.substring(0, groupIconName.lastIndexOf(".")).toLowerCase();
                    url = Tools.getResource("icons/groups/24/" + groupIconName + ".png");
                    continue;
                }
                groupIconName = "";
            }
            this.iconPath = "/groups/24/" + groupIconName + ".png";
        }
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.iconPath = null;
            }
        } else {
            this.iconPath = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getOperatorClass() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    public String toString() {
        return "operator '" + this.name + "' loaded from " + this.clazz + ", description: " + this.description + ", group: " + this.group + ", icon: " + this.iconPath;
    }

    @Override
    public int compareTo(OperatorDescription d) {
        return this.name.compareTo(d.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperatorDescription)) {
            return false;
        }
        return this.name.equals(((OperatorDescription)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Operator createOperatorInstance() throws OperatorCreationException {
        Operator operator = null;
        try {
            Constructor<?> constructor = this.clazz.getConstructor(OperatorDescription.class);
            operator = (Operator)constructor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new OperatorCreationException(0, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new OperatorCreationException(1, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (NoSuchMethodException e) {
            throw new OperatorCreationException(2, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (InvocationTargetException e) {
            throw new OperatorCreationException(3, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        return operator;
    }
}

