/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.AddListener;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.WrongNumberOfInnerOperatorsException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatorChain
extends Operator {
    private List<Operator> operators = new ArrayList<Operator>();
    private List<AddListener> addListeners = new LinkedList<AddListener>();

    public OperatorChain(OperatorDescription description) {
        super(description);
    }

    public abstract int getMaxNumberOfInnerOperators();

    public abstract int getMinNumberOfInnerOperators();

    public abstract InnerOperatorCondition getInnerOperatorCondition();

    public void addAddListener(AddListener listener) {
        this.addListeners.add(listener);
    }

    public void removeAddListener(AddListener listener) {
        this.addListeners.remove(listener);
    }

    private void fireAddEvent(Operator child) {
        Iterator<AddListener> i = this.addListeners.iterator();
        while (i.hasNext()) {
            i.next().operatorAdded(child);
        }
    }

    @Override
    public Operator cloneOperator(String name) {
        OperatorChain clone = (OperatorChain)super.cloneOperator(name);
        clone.operators = new ArrayList<Operator>();
        for (Operator originalChild : this.operators) {
            Operator clonedChild = originalChild.cloneOperator(originalChild.getName());
            clonedChild.setParent(clone);
            clone.addOperator(clonedChild);
        }
        return clone;
    }

    @Override
    public final Class[] checkIO(Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        InnerOperatorCondition condition = this.getInnerOperatorCondition();
        Class[] innerOutput = condition.checkIO(this, input);
        if (this.shouldReturnInnerOutput()) {
            return this.getAllOutputClasses(innerOutput);
        }
        return this.getDeliveredOutputClasses();
    }

    public boolean shouldReturnInnerOutput() {
        return false;
    }

    private Class[] getAllOutputClasses(Class[] innerOutput) {
        Class[] deliveredOutput = this.getDeliveredOutputClasses();
        Class[] result = new Class[deliveredOutput.length + innerOutput.length];
        System.arraycopy(deliveredOutput, 0, result, 0, deliveredOutput.length);
        System.arraycopy(innerOutput, 0, result, deliveredOutput.length, innerOutput.length);
        return result;
    }

    public final int addOperator(Operator o) {
        return this.addOperator(o, this.getNumberOfAllOperators());
    }

    public final int addOperator(Operator operator, int index) {
        if (operator == null) {
            return -1;
        }
        operator.setParent(this);
        this.operators.add(index, operator);
        Experiment experiment = this.getExperiment();
        if (experiment != null) {
            operator.registerOperator(experiment);
        }
        if (this.getNumberOfOperators() == this.getMaxNumberOfInnerOperators() + 1) {
            LogService.logMessage("More than " + this.getMaxNumberOfInnerOperators() + " inner operators in " + this.getName() + "!", 4);
        }
        this.fireAddEvent(operator);
        return index;
    }

    @Override
    protected void registerOperator(Experiment experiment) {
        super.registerOperator(experiment);
        for (Operator child : this.operators) {
            child.registerOperator(experiment);
        }
    }

    @Override
    protected void unregisterOperator(Experiment experiment) {
        super.unregisterOperator(experiment);
        for (Operator operator : this.operators) {
            operator.unregisterOperator(experiment);
        }
    }

    public void removeOperator(Operator operator) {
        this.operators.remove(operator);
    }

    public Operator getOperator(int i) {
        if (i < 0 || i >= this.getNumberOfOperators()) {
            throw new RuntimeException("Illegal operator index in getOperator() (" + this.getName() + "): " + i);
        }
        int counter = 0;
        for (Operator operator : this.operators) {
            if (!operator.isEnabled()) continue;
            if (counter == i) {
                return operator;
            }
            ++counter;
        }
        return null;
    }

    public Iterator<Operator> getOperators() {
        return this.operators.iterator();
    }

    public List<Operator> getAllInnerOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        int i = 0;
        while (i < this.operators.size()) {
            Operator innerOp = this.operators.get(i);
            children.add(innerOp);
            if (innerOp instanceof OperatorChain) {
                children.addAll(((OperatorChain)innerOp).getAllInnerOperators());
            }
            ++i;
        }
        return children;
    }

    public int getNumberOfOperators() {
        int number = 0;
        for (Operator op : this.operators) {
            if (!op.isEnabled()) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfAllOperators() {
        return this.operators.size();
    }

    public Operator getOperatorFromAll(int i) {
        return this.operators.get(i);
    }

    public int getIndexOfOperator(Operator operator, boolean useDisabled) {
        if (useDisabled) {
            return this.operators.indexOf(operator);
        }
        int index = 0;
        for (Operator current : this.operators) {
            if (!current.isEnabled()) continue;
            if (current.equals(operator)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Operator getInnerOperatorForName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(this.getName())) {
            return this;
        }
        for (Operator inner : this.operators) {
            Operator innerinner;
            if (name.equals(inner.getName())) {
                return inner;
            }
            if (!(inner instanceof OperatorChain) || (innerinner = ((OperatorChain)inner).getInnerOperatorForName(name)) == null) continue;
            return innerinner;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Operator child : this.operators) {
            child.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.getParent() == null) {
            return super.isEnabled();
        }
        return super.isEnabled() && this.getParent().isEnabled();
    }

    @Override
    public void experimentStarts() throws OperatorException {
        super.experimentStarts();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            this.getOperator(i).experimentStarts();
            ++i;
        }
    }

    @Override
    public void experimentFinished() throws OperatorException {
        super.experimentFinished();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            this.getOperator(i).experimentFinished();
            ++i;
        }
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            try {
                input = i.next().apply(input);
            }
            catch (ConcurrentModificationException e) {
                throw new UserError(this, 923);
            }
        }
        return input.getIOObjects();
    }

    @Override
    public void performAdditionalChecks() throws UserError {
        for (Operator o : this.operators) {
            if (!o.isEnabled()) continue;
            o.performAdditionalChecks();
        }
    }

    @Override
    public int checkProperties() {
        int errorCount = super.checkProperties();
        for (Operator o : this.operators) {
            if (!o.isEnabled()) continue;
            errorCount += o.checkProperties();
        }
        return errorCount;
    }

    @Override
    public int checkDeprecations() {
        int deprecationCount = super.checkDeprecations();
        for (Operator o : this.operators) {
            deprecationCount += o.checkDeprecations();
        }
        return deprecationCount;
    }

    public int checkNumberOfInnerOperators() {
        int errorCount = 0;
        if (this.getNumberOfOperators() < this.getMinNumberOfInnerOperators() || this.getNumberOfOperators() > this.getMaxNumberOfInnerOperators()) {
            int maximum = this.getMaxNumberOfInnerOperators();
            String maximumString = maximum == Integer.MAX_VALUE ? "infinity" : String.valueOf(maximum);
            String message = "Operator has " + this.getNumberOfOperators() + " " + (this.getNumberOfOperators() == 1 ? "child" : "children") + ", should be " + (this.getMinNumberOfInnerOperators() == this.getMaxNumberOfInnerOperators() ? String.valueOf(this.getMinNumberOfInnerOperators()) : " between " + this.getMinNumberOfInnerOperators() + " and " + maximumString);
            this.addError(message);
            ++errorCount;
        }
        for (Operator o : this.operators) {
            if (!(o instanceof OperatorChain) || !o.isEnabled()) continue;
            errorCount += ((OperatorChain)o).checkNumberOfInnerOperators();
        }
        return errorCount;
    }

    @Override
    protected String createExperimentTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        String tree = super.createExperimentTree(indent, selfPrefix, childPrefix, markOperator, mark);
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            Operator o = i.next();
            tree = String.valueOf(tree) + Tools.getLineSeparator() + o.createExperimentTree(indent, String.valueOf(childPrefix) + "+- ", String.valueOf(childPrefix) + (i.hasNext() ? "|  " : "   "), markOperator, mark);
        }
        return tree;
    }

    @Override
    protected final String getInnerOperatorsXML(String indent) {
        StringBuffer result = new StringBuffer();
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            result.append(i.next().getXML(indent));
        }
        return result.toString();
    }

    @Override
    public void clearErrorList() {
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            i.next().clearErrorList();
        }
        super.clearErrorList();
    }
}

