/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.wizards.ConfigurationListener;
import edu.udo.cs.yale.gui.wizards.PreviewListener;
import edu.udo.cs.yale.operator.ContainerModel;
import edu.udo.cs.yale.operator.ExperimentStoppedException;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.WrongNumberOfInnerOperatorsException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.Parameters;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operator
implements ConfigurationListener,
PreviewListener {
    private boolean[] breakPoint = new boolean[BreakpointListener.BREAKPOINT_POS_NAME.length];
    private Thread breakpointThread = null;
    private boolean enabled = true;
    private String name;
    private String userDescription;
    private OperatorChain parent;
    private IOContainer inputContainer;
    private int applyCount;
    private long startTime;
    private long loopStartTime;
    private Parameters parameters = null;
    private Map<String, Value> valueMap = new TreeMap<String, Value>();
    private List<String> errorList = new LinkedList<String>();
    private OperatorDescription operatorDescription = null;

    public Operator(OperatorDescription description) {
        this.operatorDescription = description;
        this.parameters = new Parameters(this.getParameterTypes());
        this.name = this.operatorDescription.getName();
        this.addValue(new Value("applycount", "The number of times the operator was applied.", false){

            public double getValue() {
                return Operator.this.applyCount;
            }
        });
        this.addValue(new Value("time", "The time elapsed since this operator started.", false){

            public double getValue() {
                return System.currentTimeMillis() - Operator.this.startTime;
            }
        });
        this.addValue(new Value("looptime", "The time elapsed since the current loop started.", false){

            public double getValue() {
                return System.currentTimeMillis() - Operator.this.loopStartTime;
            }
        });
    }

    public final OperatorDescription getOperatorDescription() {
        return this.operatorDescription;
    }

    public final String getOperatorClassName() {
        return this.operatorDescription.getName();
    }

    public Experiment getExperiment() {
        OperatorChain parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getExperiment();
    }

    public final String getName() {
        return this.name;
    }

    private final void setName(String newName) {
        this.name = newName;
    }

    public final String rename(String newName) {
        Experiment experiment = this.getExperiment();
        if (experiment != null) {
            experiment.unregisterName(this.name);
            this.name = experiment.registerName(newName, this);
        } else {
            this.name = newName;
        }
        return this.name;
    }

    public void setUserDescription(String description) {
        this.userDescription = description;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public final String getDeprecationInfo() {
        return this.operatorDescription.getDeprecationInfo();
    }

    public final void setParent(OperatorChain parent) {
        this.parent = parent;
    }

    public final OperatorChain getParent() {
        return this.parent;
    }

    public void remove() {
        Experiment experiment;
        if (this.parent != null) {
            this.parent.removeOperator(this);
        }
        if ((experiment = this.getExperiment()) != null) {
            this.unregisterOperator(experiment);
        }
    }

    @Deprecated
    public void register(Experiment experiment, String name) {
    }

    protected void registerOperator(Experiment experiment) {
        if (experiment != null) {
            this.setName(experiment.registerName(this.getName(), this));
        }
    }

    protected void unregisterOperator(Experiment experiment) {
        experiment.unregisterName(this.name);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStatus() {
        return String.valueOf(this.name) + " [" + this.applyCount + "]";
    }

    public int getApplyCount() {
        return this.applyCount;
    }

    public Operator cloneOperator(String name) {
        Operator clone = null;
        try {
            clone = this.operatorDescription.createOperatorInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            LogService.logMessage("Can not create clone of operator '" + this.getName() + "': " + e, 6);
            return null;
        }
        clone.setName(this.getName());
        clone.breakPoint = new boolean[]{this.breakPoint[0], this.breakPoint[1], this.breakPoint[2]};
        clone.enabled = this.enabled;
        if (this.userDescription != null) {
            clone.userDescription = this.userDescription;
        }
        clone.inputContainer = this.inputContainer;
        clone.applyCount = this.applyCount;
        clone.startTime = this.startTime;
        clone.loopStartTime = this.loopStartTime;
        clone.parameters = (Parameters)this.parameters.clone();
        clone.errorList = this.errorList;
        return clone;
    }

    public abstract IOObject[] apply() throws OperatorException;

    public abstract Class[] getInputClasses();

    public abstract Class[] getOutputClasses();

    public final Class[] getDesiredInputClasses() {
        Class[] inputClasses = this.getInputClasses();
        if (inputClasses == null) {
            return new Class[0];
        }
        return inputClasses;
    }

    public final Class[] getDeliveredOutputClasses() {
        LinkedList<Class> result = new LinkedList<Class>();
        Class[] inputClasses = this.getDesiredInputClasses();
        int i = 0;
        while (i < inputClasses.length) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (description.showParameter() && this.getParameterAsBoolean(description.getParameterName()) || description.getKeepDefault()) {
                result.add(inputClasses[i]);
            }
            ++i;
        }
        Class[] additionalOutput = this.getOutputClasses();
        if (additionalOutput != null) {
            int i2 = 0;
            while (i2 < additionalOutput.length) {
                result.add(additionalOutput[i2]);
                ++i2;
            }
        }
        Class[] resultArray = new Class[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public InputDescription getInputDescription(Class inputClass) {
        return new InputDescription(inputClass);
    }

    private IODescription getIODescription() {
        return new IODescription(this.getDesiredInputClasses(), this.getDeliveredOutputClasses());
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.isEnabled()) {
            return this.getIODescription().getOutputClasses(input, this);
        }
        return input;
    }

    public void performAdditionalChecks() throws UserError {
    }

    public int checkProperties() {
        int errorCount = 0;
        if (this.isEnabled()) {
            for (ParameterType type : this.getParameterTypes()) {
                try {
                    Object value = this.getParameters().getParameter(type.getKey());
                    if (type.isOptional() || type.getDefaultValue() != null || value != null) continue;
                    this.addError(String.valueOf(this.getName()) + ": " + type.getKey() + " is not defined!");
                    ++errorCount;
                }
                catch (UndefinedParameterError e) {
                    this.addError(String.valueOf(this.getName()) + ": " + type.getKey() + " is not defined!");
                    ++errorCount;
                }
            }
        }
        return errorCount;
    }

    public int checkDeprecations() {
        String deprecationString = this.getDeprecationInfo();
        int deprecationCount = 0;
        if (deprecationString != null) {
            this.addWarning(deprecationString);
            deprecationCount = 1;
        }
        return deprecationCount;
    }

    public final synchronized IOContainer apply(IOContainer input) throws OperatorException {
        Experiment experiment = this.getExperiment();
        if (experiment == null) {
            LogService.logMessage("Experiment of operator " + this + " is not set, probably not registered! Trying to use this operator (should work in most cases anyway)...", 2);
        }
        if (this.getDeprecationInfo() != null) {
            LogService.logMessage(this.getDeprecationInfo(), 4);
        }
        if (this.isEnabled()) {
            this.checkForStop(experiment);
            if (experiment != null) {
                experiment.setCurrentOperator(this);
            }
            ++this.applyCount;
            this.startTime = this.loopStartTime = System.currentTimeMillis();
            if (input == null) {
                throw new IllegalArgumentException("Input is null!");
            }
            this.inputContainer = input;
            if (experiment != null) {
                experiment.getRootOperator().experimentStep();
            }
            if (this.breakPoint[0]) {
                this.processBreakpoint(this.inputContainer, 0);
            }
            IOObject[] ioo = this.inputContainer.getIOObjects();
            if (LogService.isSufficientLogVerbosity(1)) {
                if (ioo.length == 0) {
                    LogService.logMessage("$b" + this.getName() + " called^b " + Tools.ordinalNumber(this.applyCount) + " time without input", 1);
                } else {
                    String iLog = "$b" + this.getName() + " called^b " + Tools.ordinalNumber(this.applyCount) + " time with input:";
                    int i = 0;
                    while (i < ioo.length) {
                        iLog = String.valueOf(iLog) + Tools.getLineSeparator() + "  " + (i + 1) + ". " + ioo[i];
                        ++i;
                    }
                    LogService.logMessage(iLog, 1);
                }
            }
            IOObject[] output = null;
            try {
                output = this.apply();
            }
            catch (UserError e) {
                if (e.getOperator() == null) {
                    e.setOperator(this);
                }
                throw e;
            }
            IOObject[] iOObjectArray = output;
            int n = 0;
            int n2 = iOObjectArray.length;
            while (n < n2) {
                IOObject ioObject = iOObjectArray[n];
                if (ioObject.getSource() == null) {
                    ioObject.setSource(this.getName());
                }
                ++n;
            }
            if (LogService.isSufficientLogVerbosity(1)) {
                if (output.length == 0) {
                    LogService.logMessage(String.valueOf(this.getName()) + " returned no additional output", 1);
                } else {
                    String oLog = String.valueOf(this.getName()) + " returned additional output:";
                    int i = 0;
                    while (i < output.length) {
                        oLog = String.valueOf(oLog) + Tools.getLineSeparator() + "  " + (i + 1) + ". " + output[i];
                        ++i;
                    }
                    LogService.logMessage(oLog, 1);
                }
            }
            LogService.logMessage(String.valueOf(this.getName()) + ": execution time was " + (System.currentTimeMillis() - this.startTime) + " ms", 0);
            IOContainer outputContainer = this.handleAdditionalOutput(this.inputContainer, output);
            if (this.breakPoint[2]) {
                this.processBreakpoint(outputContainer, 2);
            }
            return outputContainer;
        }
        return input;
    }

    protected final void checkForStop() throws ExperimentStoppedException {
        this.checkForStop(this.getExperiment());
    }

    private final void checkForStop(Experiment experiment) throws ExperimentStoppedException {
        if (experiment != null && experiment.shouldStop()) {
            this.stop();
        }
    }

    private final void stop() throws ExperimentStoppedException {
        LogService.logMessage("$bExperiment stopped.^b", 8);
        throw new ExperimentStoppedException(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        if (this.breakpointThread != null) {
            Thread thread = this.breakpointThread;
            synchronized (thread) {
                this.breakpointThread.notify();
            }
            Experiment experiment = this.getExperiment();
            if (experiment != null) {
                experiment.fireResumeEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBreakpoint(IOContainer container, int breakpointType) throws ExperimentStoppedException {
        LogService.logMessage("$b" + this.getName() + "^b: Breakpoint reached", 8);
        this.breakpointThread = Thread.currentThread();
        try {
            Experiment experiment = this.getExperiment();
            experiment.fireBreakpointEvent(this, container, breakpointType);
            Thread thread = this.breakpointThread;
            synchronized (thread) {
                while (experiment.getExperimentState() == 1) {
                    this.breakpointThread.wait();
                }
            }
            experiment.fireResumeEvent();
            if (experiment.shouldStop()) {
                this.stop();
            }
        }
        catch (InterruptedException e) {
            LogService.logException("While waiting after breakpoint", this.getExperiment(), e);
        }
    }

    private final IOContainer handleAdditionalOutput(IOContainer container, IOObject[] additional) {
        if (this.getAddOnlyAdditionalOutput()) {
            ContainerModel existingModel = null;
            int containerModelIndex = -1;
            int i = 0;
            while (i < additional.length) {
                if (additional[i] instanceof ContainerModel) {
                    existingModel = (ContainerModel)additional[i];
                    containerModelIndex = i;
                    break;
                }
                ++i;
            }
            if (existingModel == null) {
                existingModel = new ContainerModel();
            }
            LinkedList<IOObject> nonModelObjectList = new LinkedList<IOObject>();
            int i2 = 0;
            while (i2 < additional.length) {
                if (i2 != containerModelIndex) {
                    if (additional[i2] instanceof Model) {
                        existingModel.addModel((Model)additional[i2]);
                    } else {
                        nonModelObjectList.add(additional[i2]);
                    }
                }
                ++i2;
            }
            IOObject[] nonModelObjects = new IOObject[nonModelObjectList.size()];
            nonModelObjectList.toArray(nonModelObjects);
            IOContainer result = new IOContainer();
            if (existingModel.getNumberOfModels() > 0) {
                result = result.append(new IOObject[]{existingModel});
            }
            return result.append(nonModelObjects);
        }
        ContainerModel existingModel = null;
        try {
            existingModel = container.remove(ContainerModel.class);
        }
        catch (MissingIOObjectException e) {
            existingModel = new ContainerModel();
        }
        LinkedList<IOObject> nonModelObjectList = new LinkedList<IOObject>();
        int i = 0;
        while (i < additional.length) {
            if (additional[i] instanceof Model) {
                existingModel.addModel((Model)additional[i]);
            } else {
                nonModelObjectList.add(additional[i]);
            }
            ++i;
        }
        IOObject[] nonModelObjects = new IOObject[nonModelObjectList.size()];
        nonModelObjectList.toArray(nonModelObjects);
        IOContainer result = container;
        if (existingModel.getNumberOfModels() > 0) {
            result = result.append(new IOObject[]{existingModel});
        }
        return result.append(nonModelObjects);
    }

    public boolean getAddOnlyAdditionalOutput() {
        return false;
    }

    protected <T extends IOObject> T getInput(Class<T> cls) throws MissingIOObjectException {
        return this.getInput(cls, 0);
    }

    protected <T extends IOObject> T getInput(Class<T> cls, int nr) throws MissingIOObjectException {
        InputDescription description = this.getInputDescription(cls);
        if (description.showParameter()) {
            if (this.getParameterAsBoolean(description.getParameterName())) {
                return this.inputContainer.get(cls, nr);
            }
            return this.inputContainer.remove(cls, nr);
        }
        if (description.getKeepDefault()) {
            return this.inputContainer.get(cls, nr);
        }
        return this.inputContainer.remove(cls, nr);
    }

    protected boolean hasInput(Class<? extends IOObject> cls) {
        return this.inputContainer.contains(cls);
    }

    public IOContainer getInput() {
        return this.inputContainer;
    }

    protected void setInput(IOContainer input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        this.inputContainer = input;
    }

    public void experimentStarts() throws OperatorException {
        this.applyCount = 0;
    }

    public void experimentFinished() throws OperatorException {
    }

    public void setBreakpoint(int position, boolean on) {
        this.breakPoint[position] = on;
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint(0) || this.hasBreakpoint(1) || this.hasBreakpoint(2);
    }

    public boolean hasBreakpoint(int position) {
        return this.breakPoint[position];
    }

    public void inApplyLoop() throws ExperimentStoppedException {
        if (this.breakPoint[1]) {
            this.processBreakpoint(this.getIOContainerForInApplyLoopBreakpoint(), 1);
        }
        this.loopStartTime = System.currentTimeMillis();
        this.checkForStop();
    }

    protected IOContainer getIOContainerForInApplyLoopBreakpoint() {
        return IOContainer.DUMMY_IO_CONTAINER;
    }

    public void addValue(Value value) {
        this.valueMap.put(value.getKey(), value);
    }

    public final double getValue(String key) {
        Value value = this.valueMap.get(key);
        if (value != null) {
            return value.getValue();
        }
        LogService.logMessage(String.valueOf(this.getName()) + ": Illegal value requested: " + key, 4);
        return Double.NaN;
    }

    public Collection<Value> getValues() {
        return this.valueMap.values();
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String key, String value) {
        this.parameters.setParameter(key, value);
    }

    public void setListParameter(String key, List list) {
        this.parameters.setParameter(key, list);
    }

    public Object getParameter(String key) throws UndefinedParameterError {
        try {
            return this.parameters.getParameter(key);
        }
        catch (UndefinedParameterError e) {
            e.setOperator(this);
            throw e;
        }
    }

    public boolean isParameterSet(String key) throws UndefinedParameterError {
        return this.getParameter(key) != null;
    }

    public String getParameterAsString(String key) throws UndefinedParameterError {
        return this.expandString(this.replaceMacros((String)this.getParameter(key)));
    }

    public int getParameterAsInt(String key) throws UndefinedParameterError {
        return (Integer)this.getParameter(key);
    }

    public double getParameterAsDouble(String key) throws UndefinedParameterError {
        return (Double)this.getParameter(key);
    }

    public boolean getParameterAsBoolean(String key) {
        try {
            return (Boolean)this.getParameter(key);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return false;
        }
    }

    public List getParameterList(String key) throws UndefinedParameterError {
        return (List)this.getParameter(key);
    }

    public Color getParameterAsColor(String key) throws UndefinedParameterError {
        return ParameterTypeColor.string2Color((String)this.getParameter(key));
    }

    public File getParameterAsFile(String key) throws UndefinedParameterError {
        String fileName = this.getParameterAsString(key);
        if (fileName == null) {
            return null;
        }
        Experiment experiment = this.getExperiment();
        if (experiment != null) {
            return experiment.resolveFileName(fileName);
        }
        return new File(fileName);
    }

    private String expandString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int totalStart = 0;
        int start = 0;
        while ((start = str.indexOf("%{", totalStart)) >= 0) {
            result.append(str.substring(totalStart, start));
            int end = str.indexOf(125, start);
            if (end >= start) {
                String command = str.substring(start, end + 1);
                switch (command.charAt(2)) {
                    case 'n': {
                        result.append(this.getName());
                        break;
                    }
                    case 'c': {
                        result.append(this.getClass().getName());
                        break;
                    }
                    case 'a': {
                        result.append(this.applyCount);
                        break;
                    }
                    case 'b': {
                        result.append(this.applyCount + 1);
                        break;
                    }
                    case 'p': {
                        int openNumberIndex = command.indexOf(91, 3);
                        if (openNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        int closeNumberIndex = command.indexOf(93, openNumberIndex);
                        if (closeNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        if (closeNumberIndex <= openNumberIndex + 1) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        String numberString = command.substring(openNumberIndex + 1, closeNumberIndex);
                        int number = Integer.parseInt(numberString);
                        result.append(this.applyCount + number);
                        break;
                    }
                    case 't': {
                        GregorianCalendar calendar = new GregorianCalendar();
                        result.append(String.valueOf(calendar.get(1)) + "_");
                        String month = String.valueOf(calendar.get(2));
                        if (month.length() < 2) {
                            month = "0" + month;
                        }
                        result.append(String.valueOf(month) + "_");
                        String day = String.valueOf(calendar.get(5));
                        if (day.length() < 2) {
                            day = "0" + day;
                        }
                        result.append(String.valueOf(day) + "-");
                        int amPm = calendar.get(9);
                        String amPmString = amPm == 0 ? "AM" : "PM";
                        result.append(String.valueOf(amPmString) + "_");
                        String hour = String.valueOf(calendar.get(10));
                        if (hour.length() < 2) {
                            hour = "0" + hour;
                        }
                        result.append(String.valueOf(hour) + "_");
                        String minute = String.valueOf(calendar.get(12));
                        if (minute.length() < 2) {
                            minute = "0" + minute;
                        }
                        result.append(String.valueOf(minute) + "_");
                        String second = String.valueOf(calendar.get(13));
                        if (second.length() < 2) {
                            second = "0" + second;
                        }
                        result.append(second);
                        break;
                    }
                    case '%': {
                        result.append('%');
                        break;
                    }
                    default: {
                        result.append(command);
                        break;
                    }
                }
            } else {
                end = start + 2;
                result.append("%{");
            }
            totalStart = end + 1;
        }
        result.append(str.substring(totalStart));
        return result.toString();
    }

    private String replaceMacros(String value) {
        if (value == null) {
            return null;
        }
        try {
            String line = value;
            int startIndex = line.indexOf("%{");
            StringBuffer result = new StringBuffer();
            while (startIndex >= 0) {
                result.append(line.substring(0, startIndex));
                int endIndex = line.indexOf("}", startIndex + 2);
                String macroString = line.substring(startIndex + 2, endIndex);
                String macroValue = this.getExperiment().getMacroHandler().getMacro(macroString);
                if (macroValue != null) {
                    result.append(macroValue);
                } else {
                    result.append("%{" + macroString + "}");
                }
                line = line.substring(endIndex + 1);
                startIndex = line.indexOf("%{");
            }
            result.append(line);
            return result.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        Class[] inputClasses = this.getDesiredInputClasses();
        int i = 0;
        while (i < inputClasses.length) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (description.showParameter()) {
                types.add(new ParameterTypeBoolean(description.getParameterName(), "Indicates if this input object should also be returned as output.", description.getKeepDefault()));
            }
            ++i;
        }
        return types;
    }

    public ParameterType getParameterType(String name) {
        for (ParameterType current : this.getParameterTypes()) {
            if (!current.getKey().equals(name)) continue;
            return current;
        }
        return null;
    }

    public void writeXML(PrintWriter out, String indent) throws IOException {
        out.println(this.getXML(indent));
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        String breakpointString = "";
        StringBuffer breakpointBuf = null;
        boolean firstBreakpoint = true;
        int i = 0;
        while (i < BreakpointListener.BREAKPOINT_POS_NAME.length) {
            if (this.breakPoint[i]) {
                if (firstBreakpoint) {
                    breakpointBuf = new StringBuffer(" breakpoints=\"");
                    firstBreakpoint = false;
                } else {
                    breakpointBuf.append(",");
                }
                breakpointBuf.append(BreakpointListener.BREAKPOINT_POS_NAME[i]);
            }
            ++i;
        }
        if (breakpointBuf != null) {
            breakpointBuf.append("\"");
            breakpointString = breakpointBuf.toString();
        }
        result.append(String.valueOf(indent) + "<operator " + "name=\"" + this.name + "\" " + "class=\"" + this.operatorDescription.getName() + "\"" + breakpointString + (!this.enabled ? " activated=\"no\"" : "") + ">" + Tools.getLineSeparator());
        if (this.userDescription != null && this.userDescription.length() != 0) {
            result.append(String.valueOf(indent) + "    <description text=\"" + this.userDescription + "\"/>" + Tools.getLineSeparator());
        }
        result.append(this.parameters.getXML(String.valueOf(indent) + "    "));
        result.append(this.getInnerOperatorsXML(String.valueOf(indent) + "    "));
        result.append(String.valueOf(indent) + "</operator>" + Tools.getLineSeparator());
        return result.toString();
    }

    protected String getInnerOperatorsXML(String indent) {
        return "";
    }

    private static String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private static Object[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new Object[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    private static Object[] createParameterListFromXML(Element element) throws XMLException {
        LinkedList<Object[]> values = new LinkedList<Object[]>();
        Attr keyAttr = element.getAttributeNode("key");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <list> tag is not set.");
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element inner = (Element)node;
                if (inner.getTagName().toLowerCase().equals("parameter")) {
                    values.add(Operator.createParameterFromXML(inner));
                } else if (inner.getTagName().toLowerCase().equals("list")) {
                    values.add(Operator.createParameterListFromXML(inner));
                } else {
                    throw new XMLException("Ilegal inner tag for <list>: " + inner.getTagName());
                }
            }
            ++i;
        }
        return new Object[]{keyAttr.getValue(), values};
    }

    public static Operator createFromXML(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("operator")) {
            throw new XMLException("<operator> expected!");
        }
        String className = null;
        String name = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <operator> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <operator> tag is not defined! ");
        }
        name = nameAttr.getValue();
        OperatorDescription opDescr = OperatorService.getOperatorDescription(className);
        if (opDescr == null) {
            throw new XMLException("Unknown operator class: '" + className + "'!");
        }
        Operator operator = null;
        try {
            operator = opDescr.createOperatorInstance();
        }
        catch (OperatorCreationException e) {
            throw new XMLException("Cannot create operator: " + e.getMessage(), e);
        }
        operator.setName(name);
        operator.setOperatorParameters(element);
        return operator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOperatorParameters(Element element) throws XMLException {
        int i;
        Attr activationAttr;
        String className = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <operator> tag is not defined!");
        }
        className = classAttr.getValue();
        if (!this.getOperatorClassName().equals(className)) {
            throw new XMLException("Attribute 'class' of XML description and operator class do not match (XML: " + className + ", operator class: " + this.getOperatorClassName() + ")!");
        }
        String breakpointString = null;
        String activationString = null;
        Attr breakpointAttr = element.getAttributeNode("breakpoints");
        if (breakpointAttr != null) {
            breakpointString = breakpointAttr.getValue();
        }
        if ((activationAttr = element.getAttributeNode("activated")) != null) {
            activationString = activationAttr.getValue();
        }
        if (breakpointString != null) {
            boolean ok = false;
            if (breakpointString.equals("both")) {
                this.setBreakpoint(0, true);
                this.setBreakpoint(2, true);
                ok = true;
            }
            i = 0;
            while (i < BreakpointListener.BREAKPOINT_POS_NAME.length) {
                if (breakpointString.indexOf(BreakpointListener.BREAKPOINT_POS_NAME[i]) >= 0) {
                    this.setBreakpoint(i, true);
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                throw new XMLException("Breakpoint `" + breakpointString + "` is not defined!");
            }
        }
        if (activationString != null) {
            if (activationString.equals("no")) {
                this.setEnabled(false);
            } else {
                if (!activationString.equals("yes")) throw new XMLException("Activation mode `" + activationString + "` is not defined!");
                this.setEnabled(true);
            }
        }
        NodeList innerTags = element.getChildNodes();
        i = 0;
        while (i < innerTags.getLength()) {
            Node node = innerTags.item(i);
            if (node instanceof Element) {
                Object[] parameter;
                Element inner = (Element)node;
                if (inner.getTagName().toLowerCase().equals("parameter")) {
                    parameter = Operator.createParameterFromXML(inner);
                    this.getParameters().setParameter((String)parameter[0], parameter[1]);
                } else if (inner.getTagName().toLowerCase().equals("list")) {
                    parameter = Operator.createParameterListFromXML(inner);
                    this.getParameters().setParameter((String)parameter[0], parameter[1]);
                } else if (inner.getTagName().toLowerCase().equals("operator")) {
                    if (!(this instanceof OperatorChain)) throw new XMLException("No inner operators allowed for '" + this.getOperatorClassName() + "'");
                    ((OperatorChain)this).addOperator(Operator.createFromXML(inner));
                } else {
                    if (!inner.getTagName().toLowerCase().equals("description")) throw new XMLException("Ilegal inner tag for <operator>: " + inner.getTagName());
                    String description = Operator.createDescriptionFromXML(inner);
                    this.setUserDescription(description);
                }
            }
            ++i;
        }
    }

    public void clearErrorList() {
        this.errorList.clear();
    }

    public void addError(String message) {
        LogService.logMessage(String.valueOf(this.getName()) + ": " + message, 6);
        this.errorList.add(message);
    }

    public void addWarning(String message) {
        LogService.logMessage(String.valueOf(this.getName()) + ": " + message, 4);
        this.errorList.add(message);
    }

    public List getErrorList() {
        return this.errorList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logMessage(String message, int verbosityLevel) {
        LogService.logMessage(String.valueOf(this.getName()) + ": " + message, verbosityLevel);
    }

    public String toString() {
        String type = null;
        type = this.getOperatorDescription() != null ? this.getOperatorClassName() : this.getClass().getName();
        return String.valueOf(this.breakPoint[0] || this.breakPoint[1] ? "* " : "") + this.name + " (" + type + ")";
    }

    public String createExperimentTree(int indent) {
        return this.createExperimentTree(indent, "", "", null, null);
    }

    public String createMarkedExperimentTree(int indent, String mark, Operator markOperator) {
        return this.createExperimentTree(indent, "", "", markOperator, mark);
    }

    protected String createExperimentTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        if (markOperator != null && this.getName().equals(markOperator.getName())) {
            return String.valueOf(this.indent(indent - mark.length())) + mark + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
        }
        return String.valueOf(this.indent(indent)) + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
    }

    private String indent(int indent) {
        String s = "";
        while (s.length() < indent) {
            s = String.valueOf(s) + " ";
        }
        return s;
    }
}

