/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelApplier
extends Operator {
    public ModelApplier(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputExampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        LogService.logMessage("Set parameters for " + model.getClass().getName(), 0);
        List modelParameters = this.getParameterList("application_parameters");
        for (Object[] parameter : modelParameters) {
            model.setParameter((String)parameter[0], (String)parameter[1]);
        }
        LogService.logMessage("Applying " + model.getClass().getName(), 0);
        try {
            model.apply(inputExampleSet);
        }
        catch (UserError e) {
            if (e.getOperator() == null) {
                e.setOperator(this);
            }
            throw e;
        }
        return new IOObject[]{inputExampleSet};
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (Model.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{Model.class, ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList("application_parameters", "Model parameters for application (usually not needed).", new ParameterTypeString("key", "value")));
        return types;
    }
}

