/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

public class InputDescription {
    private Class inputType;
    private boolean keepDefault;
    private boolean parameter;
    private String parameterName;

    public InputDescription(Class inputType) {
        this(inputType, false, false, null);
    }

    public InputDescription(Class inputType, boolean keepDefault) {
        this(inputType, keepDefault, false, null);
    }

    public InputDescription(Class inputType, boolean keepDefault, boolean parameter) {
        this(inputType, keepDefault, parameter, parameter ? InputDescription.convertClass2ParameterName(inputType) : null);
    }

    public InputDescription(Class inputType, boolean keepDefault, boolean parameter, String parameterName) {
        this.inputType = inputType;
        this.keepDefault = keepDefault;
        this.parameter = parameter;
        this.parameterName = parameterName;
    }

    public Class getInputType() {
        return this.inputType;
    }

    public boolean getKeepDefault() {
        return this.keepDefault;
    }

    public boolean showParameter() {
        return this.parameter;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    private static String convertClass2ParameterName(Class inputType) {
        String className = inputType.getName();
        String name = className.substring(className.lastIndexOf(".") + 1);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char current = name.charAt(i);
            if (Character.isUpperCase(current)) {
                result.append("_" + Character.toLowerCase(current));
            } else {
                result.append(current);
            }
            ++i;
        }
        return "keep" + result.toString();
    }

    public String toString() {
        return "Input description for " + this.inputType + " (keep: " + this.keepDefault + ", parameter: " + this.parameter + ", name: " + this.parameterName + ")";
    }
}

