/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOMultiplyOperator
extends Operator {
    private static final String[] MULTIPLY_TYPES = new String[]{"multiply_one", "multiply_all"};
    private static final int MULTIPLY_ONE = 0;
    private static final int MULTIPLY_ALL = 1;
    private String[] objectArray = null;

    public IOMultiplyOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt("io_object");
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        LinkedList<IOObject> result = new LinkedList<IOObject>();
        Class<IOObject> clazz = this.getSelectedClass();
        int numberOfCopies = this.getParameterAsInt("number_of_copies");
        if (clazz != null) {
            switch (this.getParameterAsInt("multiply_type")) {
                case 0: {
                    int number = this.getParameterAsInt("multiply_which");
                    IOObject ioObject = this.getInput(clazz, number - 1);
                    this.addCopies(result, ioObject, numberOfCopies);
                    break;
                }
                case 1: {
                    try {
                        while (true) {
                            IOObject ioObject = this.getInput(clazz);
                            this.addCopies(result, ioObject, numberOfCopies);
                        }
                    }
                    catch (MissingIOObjectException missingIOObjectException) {
                        // empty catch block
                    }
                }
            }
        }
        IOObject[] resultArray = new IOObject[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    private void addCopies(List<IOObject> result, IOObject ioObject, int numberOfCopies) {
        result.add(ioObject);
        int i = 0;
        while (i < numberOfCopies) {
            result.add(ioObject.copy());
            ++i;
        }
    }

    @Override
    public Class[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return this.getInputClasses();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeInt("number_of_copies", "The number of copies which should be created.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("io_object", "The class of the object(s) which should be multiplied.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("multiply_type", "Defines the type of multiplying.", MULTIPLY_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("multiply_which", "Defines which input object should be multiplied (only used for deletion type 'multiply_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

