/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOConsumeOperator
extends Operator {
    private static final String[] DELETION_TYPES = new String[]{"delete_one", "delete_all", "delete_all_but"};
    private static final int DELETE_ONE = 0;
    private static final int DELETE_ALL = 1;
    private static final int DELETE_ALL_BUT = 2;
    private String[] objectArray = null;

    public IOConsumeOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt("io_object");
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Class<IOObject> clazz = this.getSelectedClass();
        if (clazz != null) {
            switch (this.getParameterAsInt("deletion_type")) {
                case 0: {
                    int number = this.getParameterAsInt("delete_which");
                    this.getInput(clazz, number - 1);
                    LogService.logMessage("Deleted " + number + ". " + clazz.getName() + ".", 2);
                    break;
                }
                case 1: {
                    int counter = 0;
                    try {
                        while (true) {
                            this.getInput(clazz);
                            ++counter;
                        }
                    }
                    catch (MissingIOObjectException e) {
                        LogService.logMessage("Deleted " + counter + " " + clazz.getName() + ".", 2);
                        break;
                    }
                }
                case 2: {
                    int counter = 0;
                    IOContainer input = this.getInput();
                    int i = 0;
                    while (i < input.size()) {
                        IOObject current = input.getElementAt(i);
                        if (!clazz.isAssignableFrom(current.getClass())) {
                            input.removeElementAt(i);
                            ++counter;
                        }
                        ++i;
                    }
                    LogService.logMessage("Deleted " + counter + " input objects.", 2);
                }
            }
        }
        return new IOObject[0];
    }

    @Override
    public Class[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory("io_object", "The class of the object(s) which should be removed.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("deletion_type", "Defines the type of deletion.", DELETION_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("delete_which", "Defines which input object should be deleted (only used for deletion type 'delete_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

