/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SimpleChainInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDirectory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.TempFileService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExperimentOperator
extends OperatorChain {
    private List<ExperimentListener> listenerList = new LinkedList<ExperimentListener>();
    private Experiment experiment;

    static {
        Yale.registerYaleProperty(new ParameterTypeInt("yale.general.randomseed", "The default random seed (-1: random random seed).", 1, Integer.MAX_VALUE, 2001));
    }

    public ExperimentOperator(OperatorDescription description) {
        this(description, null);
    }

    public ExperimentOperator(OperatorDescription description, Experiment experiment) {
        super(description);
        this.addValue(new Value("memory", "The current memory usage."){

            public double getValue() {
                return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
        });
        this.setExperiment(experiment);
        this.rename("Root");
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
        this.registerOperator(this.experiment);
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return true;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    public void addExperimentListener(ExperimentListener l) {
        this.listenerList.add(l);
    }

    public void removeExperimentListener(ExperimentListener l) {
        this.listenerList.remove(l);
    }

    public void clearListeners() {
        this.listenerList.clear();
    }

    @Override
    public void experimentStarts() throws OperatorException {
        super.experimentStarts();
        Iterator<ExperimentListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().experimentStarts();
        }
    }

    protected void experimentStep() {
        Iterator<ExperimentListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().experimentStep(this);
        }
    }

    @Override
    public void experimentFinished() throws OperatorException {
        super.experimentFinished();
        Iterator<ExperimentListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().experimentEnded();
        }
    }

    public void sendEmail(IOContainer results, Throwable e) throws UndefinedParameterError {
        String email = this.getParameterAsString("notification_email");
        if (email == null) {
            return;
        }
        LogService.logMessage("Sending notification email to '" + email + "'", 2);
        String name = email;
        int at = name.indexOf("@");
        if (at >= 0) {
            name = name.substring(0, at);
        }
        String subject = "Experiment " + this.getName() + " finished";
        String content = "Hello " + name + "," + Tools.getLineSeparator() + Tools.getLineSeparator();
        content = String.valueOf(content) + "I'm sending you a notification message on your experiment '" + this.getName() + "'." + Tools.getLineSeparator();
        File logFile = LogService.getLogFile();
        if (logFile != null) {
            content = String.valueOf(content) + "Logfile is file://" + logFile.getAbsolutePath() + Tools.getLineSeparator() + Tools.getLineSeparator();
        }
        if (e != null) {
            content = String.valueOf(content) + "Experiment failed: " + e.toString();
            subject = "Experiment " + this.getName() + " failed";
        }
        if (results != null) {
            content = String.valueOf(content) + Tools.getLineSeparator() + Tools.getLineSeparator() + "Results:";
            int i = 0;
            try {
                while (true) {
                    ResultObject result = results.get(ResultObject.class, i);
                    content = String.valueOf(content) + Tools.getLineSeparator() + Tools.getLineSeparator() + Tools.getLineSeparator() + result.toResultString();
                    ++i;
                }
            }
            catch (MissingIOObjectException exc) {
                // empty catch block
            }
        }
        Tools.sendEmail(email, subject, content);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("logverbosity", "Log verbosity level.", LogService.LOG_VERBOSITY_NAMES, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("logfile", "File to write logging information to.", "log", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile("resultfile", "File to write inputs of the ResultWriter operators to.", "res", true));
        types.add(new ParameterTypeDirectory("temp_dir", "Directory for temp files.", true));
        types.add(new ParameterTypeCategory("delete_temp_files", "Keep all or none of the generated temporary files.", TempFileService.DELETE_TEMP_FILES, 1));
        int seed = 2001;
        String seedProperty = System.getProperty("yale.general.randomseed");
        try {
            if (seedProperty != null) {
                seed = Integer.parseInt(seedProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Bad integer in property 'yale.general.randomseed', using default seed (2001).", 4);
        }
        types.add(new ParameterTypeInt("random_seed", "Global random seed for random generators (-1 for initialization by system time).", Integer.MIN_VALUE, Integer.MAX_VALUE, seed));
        types.add(new ParameterTypeString("notification_email", "Email address for the notification mail.", true));
        return types;
    }
}

