/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.ContainerModelViewer;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerModel
extends AbstractModel {
    private List<Model> models = new ArrayList<Model>();

    @Override
    public void apply(ExampleSet exampleSet) throws OperatorException {
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            i.next().apply(exampleSet);
        }
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public void updateModel(ExampleSet updateExampleSet) throws OperatorException {
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            i.next().updateModel(updateExampleSet);
        }
    }

    @Override
    public String getName() {
        return "Model";
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public void removeModel(Model model) {
        this.models.remove(model);
    }

    public int getNumberOfModels() {
        return this.models.size();
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    public <T extends Model> T getModel(Class<T> desiredClass) {
        for (Model model : this.models) {
            if (!desiredClass.isAssignableFrom(model.getClass())) continue;
            return (T)model;
        }
        return null;
    }

    @Override
    public void setParameter(String key, Object value) throws OperatorException {
        boolean ok = false;
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            try {
                i.next().setParameter(key, value);
                ok = true;
            }
            catch (OperatorException operatorException) {
                // empty catch block
            }
        }
        if (!ok) {
            throw new UserError(null, 204, this.getName(), (Object)key);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Model [");
        int i = 0;
        while (i < this.getNumberOfModels()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.getModel(i).toString());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfModels()) {
            result.append(String.valueOf(i + 1) + ". " + this.getModel(i).toResultString() + Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        if (this.getNumberOfModels() == 0) {
            return new JLabel("<html><h1>Empty model container.</h1></html>");
        }
        if (this.getNumberOfModels() == 1) {
            return this.getModel(0).getVisualizationComponent(container);
        }
        return new JScrollPane(new ContainerModelViewer(this, container));
    }
}

