/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOperator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[0];

    public CommandLineOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String command = this.getParameterAsString("command");
        boolean logOut = this.getParameterAsBoolean("log_stdout");
        boolean logErr = this.getParameterAsBoolean("log_stderr");
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (logErr) {
                this.logOutput("stderr:", process.getErrorStream());
            }
            if (logOut) {
                this.logOutput("stdout:", process.getInputStream());
            }
            Tools.waitForProcess(this, process, command);
            LogService.logMessage("Program exited succesfully.", 2);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 310, new Object[]{command, e.getMessage()});
        }
        return new IOObject[0];
    }

    private void logOutput(String message, InputStream in) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuffer buffer = new StringBuffer(message);
        while ((line = bin.readLine()) != null) {
            buffer.append(Tools.getLineSeparator());
            buffer.append(line);
        }
        LogService.logMessage(buffer.toString(), 8);
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString("command", "Command to execute.", false));
        types.add(new ParameterTypeBoolean("log_stdout", "If set to true, the stdout stream of the command is redirected to the logfile.", true));
        types.add(new ParameterTypeBoolean("log_stderr", "If set to true, the stderr stream of the command is redirected to the logfile.", true));
        return types;
    }
}

