/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.wizards;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.gui.EditorCellRenderer;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSourceConfigurationWizardValueTypeTable
extends ExtendedJTable {
    private static final long serialVersionUID = -6402806364622312588L;

    public ExampleSourceConfigurationWizardValueTypeTable(List<AttributeDataSource> sources, List<String[]> data) {
        super(false);
        this.setAutoResizeMode(0);
        this.setModel(new ExampleSourceConfigurationWizardValueTypeTableModel(sources, data));
        this.update();
    }

    public void guessValueTypes() {
        ((ExampleSourceConfigurationWizardValueTypeTableModel)this.getModel()).guessValueTypes();
    }

    public void update() {
        ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        TableColumnModel columnModel = this.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            TableColumn tableColumn = columnModel.getColumn(i);
            tableColumn.setPreferredWidth(120);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        String[] allValueTypes = Ontology.ATTRIBUTE_VALUE_TYPE.getNames();
        String[] valueTypes = new String[allValueTypes.length - 1];
        System.arraycopy(allValueTypes, 1, valueTypes, 0, valueTypes.length);
        JComboBox<String> typeBox = new JComboBox<String>(valueTypes);
        typeBox.setBackground(UIManager.getColor("Table.cellBackground"));
        return new DefaultCellEditor(typeBox);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new EditorCellRenderer(this.getCellEditor(row, column));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExampleSourceConfigurationWizardValueTypeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8459288119418286682L;
        private List<AttributeDataSource> sources;
        private List<String[]> data;

        public ExampleSourceConfigurationWizardValueTypeTableModel(List<AttributeDataSource> sources, List<String[]> data) {
            this.sources = sources;
            this.data = data;
            this.guessValueTypes();
        }

        public void guessValueTypes() {
            if (this.data.size() == 0) {
                return;
            }
            int c = 0;
            while (c < this.getColumnCount()) {
                int valueType = 3;
                int r = 0;
                while (r < this.getRowCount()) {
                    block6: {
                        String value;
                        String[] row = this.data.get(r);
                        if (c < row.length && (value = this.data.get(r)[c]) != null && !value.equals("?")) {
                            try {
                                double d = Double.parseDouble(value);
                                if (valueType != 3 || (double)((int)d) == d) break block6;
                                valueType = 4;
                            }
                            catch (NumberFormatException e) {
                                valueType = 1;
                                break;
                            }
                        }
                    }
                    ++r;
                }
                this.setValueAt(Ontology.VALUE_TYPE_NAMES[valueType], 0, c);
                ++c;
            }
        }

        @Override
        public int getColumnCount() {
            return this.sources.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String valueTypeName = (String)value;
            int valueType = 1;
            int i = 0;
            while (i < Ontology.VALUE_TYPE_NAMES.length) {
                if (Ontology.VALUE_TYPE_NAMES[i].equals(valueTypeName)) {
                    valueType = i;
                    break;
                }
                ++i;
            }
            AttributeDataSource source = this.sources.get(columnIndex);
            Attribute oldAttribute = source.getAttribute();
            source.setAttribute(AttributeFactory.changeValueType(oldAttribute, valueType));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Ontology.VALUE_TYPE_NAMES[this.sources.get(columnIndex).getAttribute().getValueType()];
        }

        @Override
        public String getColumnName(int column) {
            return this.sources.get(column).getAttribute().getName();
        }
    }
}

