/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.wizards;

import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.gui.EditorCellRenderer;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSourceConfigurationWizardAttributeTypeTable
extends ExtendedJTable {
    private static final long serialVersionUID = -2517765684242352099L;

    public ExampleSourceConfigurationWizardAttributeTypeTable(List<AttributeDataSource> sources) {
        super(false);
        this.setAutoResizeMode(0);
        this.setModel(new ExampleSourceConfigurationWizardAttributeTypeTableModel(sources));
        this.update();
    }

    public void update() {
        ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        TableColumnModel columnModel = this.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            TableColumn tableColumn = columnModel.getColumn(i);
            tableColumn.setPreferredWidth(120);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        JComboBox<String> typeBox = new JComboBox<String>(Attributes.KNOWN_ATTRIBUTE_TYPES);
        typeBox.setBackground(UIManager.getColor("Table.cellBackground"));
        return new DefaultCellEditor(typeBox);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new EditorCellRenderer(this.getCellEditor(row, column));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExampleSourceConfigurationWizardAttributeTypeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6609321134250471524L;
        private List<AttributeDataSource> sources;

        public ExampleSourceConfigurationWizardAttributeTypeTableModel(List<AttributeDataSource> sources) {
            this.sources = sources;
        }

        @Override
        public int getColumnCount() {
            return this.sources.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String type = (String)value;
            this.sources.get(columnIndex).setType(type);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.sources.get(columnIndex).getType();
        }

        @Override
        public String getColumnName(int column) {
            return this.sources.get(column).getAttribute().getName();
        }
    }
}

