/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.wizards;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.wizards.AbstractConfigurationWizard;
import edu.udo.cs.yale.gui.wizards.ConfigurationListener;
import edu.udo.cs.yale.gui.wizards.ExampleSourceConfigurationWizardAttributeTypeTable;
import edu.udo.cs.yale.gui.wizards.ExampleSourceConfigurationWizardDataTable;
import edu.udo.cs.yale.gui.wizards.ExampleSourceConfigurationWizardValueTypeTable;
import edu.udo.cs.yale.operator.parameter.Parameters;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ExampleSourceConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 1261772342282270078L;
    private static final int TITLE_STEP = 0;
    private static final int DATA_LOADING_STEP = 1;
    private static final int COLUMN_STEP = 2;
    private static final int NAME_STEP = 3;
    private static final int VALUE_TYPE_STEP = 4;
    private static final int ATTRIBUTE_TYPE_STEP = 5;
    private static final int RESULT_FILE_STEP = 6;
    private ArrayList<AttributeDataSource> sources = new ArrayList();
    private List<String[]> data = new ArrayList<String[]>();
    private JTextField fileTextField = new JTextField(40);
    private JTextField commentCharField = new JTextField("#");
    private JRadioButton semicolonButton = new JRadioButton("separated by ;");
    private JRadioButton commaButton = new JRadioButton("separated by ,");
    private JRadioButton tabButton = new JRadioButton("separated by tabulars [\\t]");
    private JRadioButton whiteSpaceButton = new JRadioButton("separated by any white space [\\s+]");
    private JRadioButton regExpButton = new JRadioButton("separation defined by a regular expression (default)");
    private JTextField columnSeparatorTextField = new JTextField(",\\s*|;\\s*|\\s+");
    private JCheckBox firstRowAsNames = new JCheckBox("Use first row for column names", false);
    private ExampleSourceConfigurationWizardDataTable dataView = new ExampleSourceConfigurationWizardDataTable(this.sources, this.data);
    private JScrollPane dataViewPane = new JScrollPane(this.dataView);
    private ExampleSourceConfigurationWizardValueTypeTable valueTypeView = new ExampleSourceConfigurationWizardValueTypeTable(this.sources, this.data);
    private ExampleSourceConfigurationWizardAttributeTypeTable attributeTypeView = new ExampleSourceConfigurationWizardAttributeTypeTable(this.sources);
    private JTextField resultFileField = new JTextField(40);

    public ExampleSourceConfigurationWizard(ConfigurationListener listener) {
        super("Example Source Wizard", listener);
        this.dataViewPane.setVisible(false);
        this.addTitleStep();
        this.addDataLoadingStep();
        this.addColumnSeparatorStep();
        this.addNameDefinitionStep();
        this.addValueTypeDefinitionStep();
        this.addAttributeTypeDefinitionStep();
        this.addResultFileDefinitionStep();
        this.addBottomComponent(this.dataViewPane);
    }

    private void addTitleStep() {
        JPanel panel = SwingTools.createTextPanel("Welcome to the Example Source Wizard", "This wizard will guide you through the process of data loading and meta data definition. Using this wizard will involve the following steps:<ul><li>Selection of a data file</li><li>Definition of the column separators</li><li>Definition of the attribute names</li><li>Definition of the attribute value types</li><li>Definition of special attributes like labels or IDs</li><li>Saving the data and meta data into files used by the operator</li></ul>");
        this.addStep(panel);
    }

    private void addDataLoadingStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a data file...", "Please specify the location of a data file. The format can almost be arbitrary as long as it is in any way a attribute value format with columns for attribute values and rows for examples.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("File: ");
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = -1;
        layout.setConstraints(this.fileTextField, c);
        content.add(this.fileTextField);
        JButton chooseFileButton = new JButton("Choose...");
        chooseFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile((Component)ExampleSourceConfigurationWizard.this, null, true, null, null);
                ExampleSourceConfigurationWizard.this.fileTextField.setText(file.getAbsolutePath());
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(chooseFileButton, c);
        content.add(chooseFileButton);
        label = new JLabel("Comment characters (optionally): ");
        c.weightx = 0.0;
        c.gridwidth = 1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = -1;
        layout.setConstraints(this.commentCharField, c);
        content.add(this.commentCharField);
        JPanel fillPanel = new JPanel();
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        JPanel yFillPanel = new JPanel();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(yFillPanel, c);
        content.add(yFillPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addColumnSeparatorStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a column separator...", "Please specify a column separator. The default separator will separate columns after , or ; followed by an arbitrary number of white spaces or by white space alone. Please note that only the first few lines of the data file will be shown.");
        this.regExpButton.setSelected(true);
        Box buttonBox = new Box(1);
        this.semicolonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.semicolonButton);
        this.commaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.commaButton);
        this.tabButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.tabButton);
        this.whiteSpaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.whiteSpaceButton);
        this.regExpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.regExpButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.semicolonButton);
        group.add(this.commaButton);
        group.add(this.tabButton);
        group.add(this.whiteSpaceButton);
        group.add(this.regExpButton);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.gridheight = 2;
        layout.setConstraints(buttonBox, c);
        content.add(buttonBox);
        JLabel label = new JLabel("Regular expression: ");
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        layout.setConstraints(label, c);
        content.add(label);
        GridBagLayout regExpLayout = new GridBagLayout();
        GridBagConstraints regExpC = new GridBagConstraints();
        JPanel regExpPanel = new JPanel(regExpLayout);
        regExpC.fill = 2;
        regExpC.insets = new Insets(7, 7, 7, 7);
        regExpC.gridwidth = -1;
        regExpC.weightx = 1.0;
        regExpLayout.setConstraints(this.columnSeparatorTextField, regExpC);
        regExpPanel.add(this.columnSeparatorTextField);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        regExpC.gridwidth = 0;
        regExpC.weightx = 0.0;
        regExpLayout.setConstraints(updateButton, regExpC);
        regExpPanel.add(updateButton);
        c.gridwidth = 0;
        c.weightx = 1.0;
        layout.setConstraints(regExpPanel, c);
        content.add(regExpPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addNameDefinitionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify the column names...", "Please specify if the names can be taken from the first line of the data file.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        this.firstRowAsNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        c.gridwidth = 0;
        layout.setConstraints(this.firstRowAsNames, c);
        content.add(this.firstRowAsNames);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addValueTypeDefinitionStep() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel textPanel = SwingTools.createTextPanel("Please specify the attribute value types...", "Please specify the attribute value types. YALE tries to guess the value types based on the sample data loaded before but some adjustments might be necessary.");
        content.add((Component)textPanel, "North");
        JScrollPane valueTypeViewPane = new JScrollPane(this.valueTypeView);
        valueTypeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Attribute Value Types")));
        content.add((Component)valueTypeViewPane, "Center");
        this.addStep(content);
    }

    private void addAttributeTypeDefinitionStep() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel textPanel = SwingTools.createTextPanel("Please specify special attributes...", "Please specify special attribues if there are any. You can specify arbitrary special attributes in the Attribute Editor but in this Wizard only the most important types (label, id...) are supported.");
        content.add((Component)textPanel, "North");
        JScrollPane typeViewPane = new JScrollPane(this.attributeTypeView);
        typeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Attribute Types")));
        content.add((Component)typeViewPane, "Center");
        this.addStep(content);
    }

    private void addResultFileDefinitionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a file name...", "Please specify a file name which is used for the created attribute description file (.aml) based on the settings before. A corresponding data file will automatically be saved with the extension \".dat\". Please note that existing files with these names will be overwritten. Both files are necessary parameters for the ExampleSource operator and will - like all other important parameters - automatically be defined for this operator after this wizard was finished.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Result file name: ");
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = -1;
        layout.setConstraints(this.resultFileField, c);
        content.add(this.resultFileField);
        JButton chooseFileButton = new JButton("Choose...");
        chooseFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile((Component)ExampleSourceConfigurationWizard.this, null, false, "aml", "attribute description file");
                ExampleSourceConfigurationWizard.this.resultFileField.setText(file.getAbsolutePath());
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(chooseFileButton, c);
        content.add(chooseFileButton);
        JPanel yFillPanel = new JPanel();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(yFillPanel, c);
        content.add(yFillPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void reloadData() {
        String defaultName;
        this.sources.clear();
        this.data.clear();
        if (this.fileTextField.getText().trim().length() == 0) {
            return;
        }
        File file = new File(this.fileTextField.getText());
        String commentString = this.commentCharField.getText();
        String columnSeparators = this.getColumnSeparators();
        boolean firstLineAsNames = this.firstRowAsNames.isSelected();
        String[] columnNames = null;
        int maxColumns = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            int counter = 0;
            boolean first = true;
            while ((line = in.readLine()) != null && counter <= 10) {
                if (commentString != null && commentString.trim().length() > 0 && line.startsWith(commentString)) continue;
                String[] columns = line.trim().split(columnSeparators);
                maxColumns = Math.max(maxColumns, columns.length);
                if (first) {
                    if (firstLineAsNames) {
                        columnNames = columns;
                    } else {
                        this.data.add(columns);
                    }
                    first = false;
                } else {
                    this.data.add(columns);
                }
                ++counter;
            }
            in.close();
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("Cannot load data: " + e.getMessage(), e);
        }
        if (columnNames == null) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            columnNames = new String[maxColumns];
            int i = 0;
            while (i < columnNames.length) {
                columnNames[i] = String.valueOf(defaultName) + " (" + (i + 1) + ")";
                ++i;
            }
        } else if (columnNames.length < maxColumns) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String[] newColumnNames = new String[maxColumns];
            System.arraycopy(columnNames, 0, newColumnNames, 0, columnNames.length);
            int i = columnNames.length;
            while (i < newColumnNames.length) {
                newColumnNames[i] = String.valueOf(defaultName) + " (" + (i + 1) + ")";
                ++i;
            }
        }
        int i = 0;
        while (i < maxColumns) {
            this.sources.add(new AttributeDataSource(AttributeFactory.createAttribute(columnNames[i], 1), file, i, "attribute"));
            ++i;
        }
        this.valueTypeView.guessValueTypes();
    }

    private String getColumnSeparators() {
        String columnSeparators = this.columnSeparatorTextField.getText();
        if (this.semicolonButton.isSelected()) {
            columnSeparators = ";";
        } else if (this.commaButton.isSelected()) {
            columnSeparators = ",";
        } else if (this.tabButton.isSelected()) {
            columnSeparators = "\\t";
        } else if (this.whiteSpaceButton.isSelected()) {
            columnSeparators = "\\s+";
        }
        return columnSeparators;
    }

    private void updateViews() {
        this.dataView.update();
        this.dataViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Data Example (" + this.data.size() + " rows, " + this.sources.size() + " columns)")));
        this.valueTypeView.update();
        this.attributeTypeView.update();
    }

    protected void performStepAction(int currentStep) {
        if (currentStep > 1 && currentStep < this.getNumberOfSteps() - 1) {
            this.dataViewPane.setVisible(true);
        } else {
            this.dataViewPane.setVisible(false);
        }
        switch (currentStep) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.reloadData();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                int i = 1;
                while (i < Attributes.KNOWN_ATTRIBUTE_TYPES.length) {
                    this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
                    ++i;
                }
                break;
            }
        }
        this.updateViews();
    }

    protected void finish(ConfigurationListener listener) {
        String resultFileName = this.resultFileField.getText().trim();
        if (this.sources.size() == 0 || this.data.size() == 0) {
            SwingTools.showVerySimpleErrorMessage("You must specify a data file and proper settings - the operator will not work without this." + Tools.getLineSeparator() + "Please select \"Cancel\" if you want to abort this wizard.");
        } else if (resultFileName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("You must specify a file name for the attribute description file - " + Tools.getLineSeparator() + "the operator will not work without this. Please select \"Cancel\" if you want" + Tools.getLineSeparator() + "to abort this wizard.");
        } else {
            File attributeFile = new File(resultFileName);
            File dataFile = new File(String.valueOf(resultFileName.substring(0, resultFileName.lastIndexOf(".") + 1)) + "dat");
            try {
                this.writeData(dataFile);
                this.writeAttributeDescriptions(attributeFile);
            }
            catch (IOException e) {
                SwingTools.showErrorMessage("ExampleSource Configuation Wizard was not able to write a file.", e);
            }
            Parameters parameters = listener.getParameters();
            parameters.setParameter("attributes", attributeFile.getAbsolutePath());
            parameters.setParameter("column_separators", "\\t");
            parameters.setParameter("comment_chars", this.commentCharField.getText());
            listener.setParameters(parameters);
            this.dispose();
            YaleGUI.getMainFrame().getPropertyTable().refresh();
        }
    }

    private void writeData(File file) throws IOException {
        int i = 0;
        while (i < this.sources.size()) {
            AttributeDataSource source = this.sources.get(i);
            source.setSource(file, i);
            ++i;
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        File originalDataFile = new File(this.fileTextField.getText());
        String commentString = this.commentCharField.getText();
        String columnSeparators = this.getColumnSeparators();
        boolean firstLineAsNames = this.firstRowAsNames.isSelected();
        try {
            BufferedReader in = new BufferedReader(new FileReader(originalDataFile));
            String line = null;
            boolean first = true;
            while ((line = in.readLine()) != null) {
                if (commentString != null && commentString.trim().length() > 0 && line.startsWith(commentString)) continue;
                String[] columns = line.trim().split(columnSeparators);
                if (first) {
                    if (!firstLineAsNames) {
                        this.writeColumnData(out, columns);
                    }
                    first = false;
                    continue;
                }
                this.writeColumnData(out, columns);
            }
            in.close();
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("Cannot re-write data: " + e.getMessage(), e);
        }
        out.close();
    }

    private void writeColumnData(PrintWriter out, String[] columnData) {
        int col = 0;
        while (col < columnData.length) {
            if (col != 0) {
                out.print("\t");
            }
            out.print(columnData[col]);
            ++col;
        }
        out.println();
    }

    private void writeAttributeDescriptions(File file) {
        if (file != null) {
            try {
                this.writeXML(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
    }

    private void writeXML(File attFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(attFile));
        File defaultSource = this.sources.get(0).getFile();
        String relativePath = Tools.getRelativePath(defaultSource, attFile);
        out.println("<attributeset default_source=\"" + relativePath + "\">");
        Iterator<AttributeDataSource> i = this.sources.iterator();
        int c = 0;
        while (i.hasNext()) {
            AttributeDataSource ads = i.next();
            Attribute attribute = ads.getAttribute();
            if (attribute.isNominal()) {
                for (String[] dataRow : this.data) {
                    attribute.getMapping().mapString(dataRow[c]);
                }
            }
            ads.writeXML(out, defaultSource);
            ++c;
        }
        out.println("</attributeset>");
        out.close();
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<AttributeDataSource> i = this.sources.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            columns.toArray(names);
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, String.valueOf(type) + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                for (AttributeDataSource source : columns) {
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.updateViews();
                }
            }
        }
    }
}

