/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.wizards;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.wizards.AbstractConfigurationWizard;
import edu.udo.cs.yale.gui.wizards.ConfigurationListener;
import edu.udo.cs.yale.gui.wizards.DBExampleSourceConfigurationWizardDataTable;
import edu.udo.cs.yale.operator.parameter.Parameters;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.jdbc.DatabaseHandler;
import edu.udo.cs.yale.tools.jdbc.DatabaseService;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DBExampleSourceConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 5127262335077061590L;
    private static final String USER_DEFINED_STRING = "User Defined URL (next step)";
    private static final int STEP_USER_DATA = 2;
    private static final int STEP_TABLE_SELECTION = 3;
    private static final int STEP_TYPE_DEFINITION = 4;
    private transient DatabaseHandler handler = null;
    private boolean isConnected = false;
    Map<String, List<String>> attributeNameMap = new LinkedHashMap<String, List<String>>();
    private JComboBox systemComboBox;
    private JTextField serverField = new JTextField(40);
    private JTextField urlField = new JTextField(40);
    private JTextField databaseNameField = new JTextField(40);
    private JTextField userNameField = new JTextField(40);
    private JPasswordField passwordField = new JPasswordField(40);
    private String password = null;
    private boolean passwordFromTextField = false;
    private JList tableList = new JList();
    private JList attributeList = new JList();
    private JTextArea whereTextArea = new JTextArea(4, 20);
    private JTextArea sqlQueryTextArea = new JTextArea(4, 20);
    private Map<String, String> attributeTypeMap = new HashMap<String, String>();
    private DBExampleSourceConfigurationWizardDataTable dataView = new DBExampleSourceConfigurationWizardDataTable();

    public DBExampleSourceConfigurationWizard(ConfigurationListener listener) {
        super("Database Example Source Wizard", listener);
        this.addTitleStep();
        this.addDBSystemSelectionStep();
        this.addUserDataStep();
        this.addTableSelectionStep();
        this.addSpecialAttributesStep();
        this.updateSystemSelection();
    }

    private void addTitleStep() {
        StringBuffer titleString = new StringBuffer();
        titleString.append("This wizard will guide you through the process of data loading from databases. Using this wizard will involve the following steps:<ul><li>Selection of a database</li><li>Definition of the username and password</li><li>Selection of tables and attributes (SQL query)</li><li>Definition of special attributes like labels or IDs</li></ul>");
        String[] driverNames = DatabaseService.getAllDriverNames();
        titleString.append("<br>The currently available JDBC drivers are:<ul>");
        String[] stringArray = driverNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            titleString.append("<li>" + s + "</li>");
            ++n;
        }
        titleString.append("</ul>Please make sure to copy missing drivers into the directory lib/jdbc and restart YALE in order to make additional drivers available.");
        JPanel panel = SwingTools.createTextPanel("Welcome to the Database Example Source Wizard", titleString.toString());
        this.addStep(panel);
    }

    private void addDBSystemSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify your database system...", "Please specify your database system. If your system is not available, you can select \"User Defined URL (next step)\" and define an appropriate connection URL for your system in the next step. If the connection fails because no suitable driver is available, you might copy a driver library into the directory lib/jdbc and it will be available after the next start of YALE.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Database System:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        String[] knownNames = DatabaseService.getDBSystemNames();
        String[] names = new String[knownNames.length + 1];
        System.arraycopy(knownNames, 0, names, 0, knownNames.length);
        names[names.length - 1] = USER_DEFINED_STRING;
        this.systemComboBox = new JComboBox<String>(names);
        this.systemComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSystemSelection();
            }
        });
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.systemComboBox, c);
        content.add(this.systemComboBox);
        label = new JLabel("Server Name or IP:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.serverField, c);
        content.add(this.serverField);
        label = new JLabel("Database Name:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.databaseNameField, c);
        content.add(this.databaseNameField);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addUserDataStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify the connection data...", "Please check the connection URL and adapt it if necessary (or define it in cases where your database system was not available in the dialog before). Please specify the user name and the password. If the password field remains empty you will be prompted for it during connections. You can validate the connection to the database by pressing the \"Test Connection\" button. Please note that after pressing \"Next\" a connection to your database will be made in order to retrieve table and attribute names (this may take some minutes).");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("URL:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.urlField, c);
        content.add(this.urlField);
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        label = new JLabel("User:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.userNameField, c);
        content.add(this.userNameField);
        label = new JLabel("Password:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.passwordField, c);
        content.add(this.passwordField);
        JPanel testButtonPanel = new JPanel(new FlowLayout(1));
        JButton testButton = new JButton("Test Connection");
        testButton.setToolTipText("Tests the connection to the database based on the current settings.");
        testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSourceConfigurationWizard.this.testConnection();
            }
        });
        testButtonPanel.add(testButton);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(testButtonPanel, c);
        content.add(testButtonPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addTableSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please select tables and attributes...", "Please specify the tables, the attributes and an optional where clause which will be used to create a query statement to retrieve the data. You can modify the statement in the text field below.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Tables:");
        c.weightx = 0.0;
        c.gridwidth = 1;
        layout.setConstraints(label, c);
        content.add(label);
        label = new JLabel("Attributes:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        label = new JLabel("Where Clause:");
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        content.add(label);
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateAttributeNames();
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        c.weighty = 1.0;
        c.gridwidth = 1;
        JScrollPane tablePane = new JScrollPane(this.tableList);
        layout.setConstraints(tablePane, c);
        content.add(tablePane);
        this.attributeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        c.gridwidth = -1;
        JScrollPane attributePane = new JScrollPane(this.attributeList);
        layout.setConstraints(attributePane, c);
        content.add(attributePane);
        this.whereTextArea.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        c.gridwidth = 0;
        JScrollPane whereTextPane = new JScrollPane(this.whereTextArea);
        layout.setConstraints(whereTextPane, c);
        content.add(whereTextPane);
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        GridBagLayout sqlLayout = new GridBagLayout();
        GridBagConstraints sqlConstraints = new GridBagConstraints();
        sqlConstraints.fill = 1;
        sqlConstraints.weightx = 0.0;
        sqlConstraints.weighty = 0.0;
        sqlConstraints.insets = new Insets(7, 7, 7, 7);
        JPanel sqlQueryPanel = new JPanel(sqlLayout);
        c.weightx = 0.0;
        c.gridwidth = -1;
        label = new JLabel("SQL Query:");
        sqlLayout.setConstraints(label, sqlConstraints);
        sqlQueryPanel.add(label);
        JScrollPane sqlQueryPane = new JScrollPane(this.sqlQueryTextArea);
        sqlConstraints.weightx = 1.0;
        sqlConstraints.weighty = 1.0;
        sqlLayout.setConstraints(sqlQueryPane, sqlConstraints);
        sqlQueryPanel.add(sqlQueryPane);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(sqlQueryPanel, c);
        content.add(sqlQueryPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addSpecialAttributesStep() {
        JPanel panel = SwingTools.createTextPanel("Please define special attributes...", "Please define which columns should be used as special attributes like labels or Ids (if any). After pressing finish the necessary settings will be made for the operator.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JScrollPane typeViewPane = new JScrollPane(this.dataView);
        typeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Data and Attribute Types View (Sample)")));
        layout.setConstraints(typeViewPane, c);
        content.add(typeViewPane);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    protected void performStepAction(int currentStep) {
        if (currentStep == 2) {
            this.password = null;
            if (this.systemComboBox.getSelectedIndex() < DatabaseService.getJDBCProperties().size()) {
                this.urlField.setText(this.createPredefinedDatabaseURL());
            }
        } else if (currentStep == 3) {
            if (this.tableList.getModel().getSize() == 0) {
                try {
                    this.retrieveTableAndAttributeNames();
                }
                catch (SQLException e) {
                    this.showConnectionError("Cannot retrieve table and attribute names", e);
                }
            }
        } else if (currentStep == 4) {
            try {
                this.updateDataView();
            }
            catch (SQLException e) {
                this.showConnectionError("Cannot retrieve sample data", e);
            }
        }
    }

    private void updateSystemSelection() {
        if (this.systemComboBox.getSelectedIndex() >= DatabaseService.getJDBCProperties().size()) {
            this.serverField.setEnabled(false);
            this.databaseNameField.setEnabled(false);
            this.urlField.setText("");
        } else {
            this.serverField.setEnabled(true);
            this.databaseNameField.setEnabled(true);
        }
    }

    private String getDatabaseURL() {
        return this.urlField.getText().trim();
    }

    private String createPredefinedDatabaseURL() {
        int index = this.systemComboBox.getSelectedIndex();
        String serverName = this.serverField.getText().trim();
        if (serverName == null || serverName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database server name or IP!");
            return "";
        }
        String databaseName = this.databaseNameField.getText().trim();
        if (databaseName == null || databaseName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database name!");
            return "";
        }
        String portString = "";
        String defaultPort = DatabaseService.getJDBCProperties().get(index).getDefaultPort();
        if (defaultPort.length() > 0) {
            portString = ":" + defaultPort;
        }
        return String.valueOf(DatabaseService.getJDBCProperties().get(index).getUrlPrefix()) + serverName + portString + DatabaseService.getJDBCProperties().get(index).getDbNameSeperator() + databaseName;
    }

    private void testConnection() {
        try {
            if (!this.connect()) {
                throw new SQLException("Connection was not possible!");
            }
            this.disconnect();
            JOptionPane.showMessageDialog(this, "Connection to database is possible.", "Connection OK", 1);
        }
        catch (SQLException e) {
            this.showConnectionError(null, e);
        }
    }

    private boolean connect() throws SQLException {
        String urlString = this.getDatabaseURL();
        if (urlString != null && urlString.length() > 0) {
            if (this.isConnected) {
                this.handler.disconnect();
                this.handler = null;
            }
            this.handler = new DatabaseHandler(urlString);
            String userName = null;
            String passwd = null;
            if (urlString.indexOf("AuthenticationMethod") <= 0) {
                userName = this.userNameField.getText().trim();
                if (userName == null || userName.length() == 0) {
                    SwingTools.showVerySimpleErrorMessage("Please specify a user name!");
                    return false;
                }
                passwd = this.password;
                if (passwd == null) {
                    passwd = new String(this.passwordField.getPassword());
                    if (passwd == null || passwd.length() == 0) {
                        passwd = Yale.getInputHandler().inputPassword("Password for user '" + userName + "' required:");
                        this.passwordFromTextField = false;
                    } else {
                        this.passwordFromTextField = true;
                    }
                }
            }
            this.handler.connect(userName, passwd, true);
            this.password = passwd;
            this.isConnected = true;
            return true;
        }
        SwingTools.showVerySimpleErrorMessage("Please specify the necessary connection data!");
        return false;
    }

    private void disconnect() throws SQLException {
        if (this.isConnected) {
            this.handler.disconnect();
            this.handler = null;
            this.isConnected = false;
        }
    }

    private void retrieveTableAndAttributeNames() throws SQLException {
        this.connect();
        this.attributeNameMap.clear();
        if (this.handler != null) {
            Map<String, List<String>> newAttributeMap = this.handler.getAllTableMetaData();
            this.attributeNameMap.putAll(newAttributeMap);
        }
        this.disconnect();
        String[] allNames = new String[this.attributeNameMap.size()];
        this.attributeNameMap.keySet().toArray(allNames);
        this.tableList.removeAll();
        this.tableList.setListData(allNames);
    }

    private void updateAttributeNames() {
        Object[] selection;
        boolean singleTable = this.tableList.getSelectedValues().length == 1;
        LinkedList<String> allAttributeNames = new LinkedList<String>();
        Object[] objectArray = selection = this.tableList.getSelectedValues();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            String tableName = (String)o;
            List<String> attributeNames = this.attributeNameMap.get(tableName);
            if (attributeNames != null) {
                for (String currentAttributeName : attributeNames) {
                    if (singleTable) {
                        allAttributeNames.add(this.createAttributeName(currentAttributeName, singleTable));
                        continue;
                    }
                    allAttributeNames.add(currentAttributeName);
                }
            }
            ++n;
        }
        this.attributeList.removeAll();
        String[] nameArray = new String[allAttributeNames.size()];
        allAttributeNames.toArray(nameArray);
        this.attributeList.setListData(nameArray);
    }

    private void updateDataView() throws SQLException {
        String currentName;
        int i;
        boolean singleTable;
        this.attributeTypeMap.clear();
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        String[] usedAttributeNames = null;
        boolean bl = singleTable = this.tableList.getSelectedValues().length == 1;
        if (attributeSelection.length == 0) {
            usedAttributeNames = new String[this.attributeList.getModel().getSize()];
            i = 0;
            while (i < this.attributeList.getModel().getSize()) {
                currentName = (String)this.attributeList.getModel().getElementAt(i);
                usedAttributeNames[i] = this.createAttributeName(currentName, singleTable);
                this.attributeTypeMap.put(usedAttributeNames[i], "attribute");
                ++i;
            }
        } else {
            usedAttributeNames = new String[attributeSelection.length];
            i = 0;
            while (i < attributeSelection.length) {
                currentName = (String)attributeSelection[i];
                usedAttributeNames[i] = this.createAttributeName(currentName, singleTable);
                this.attributeTypeMap.put(usedAttributeNames[i], "attribute");
                ++i;
            }
        }
        LinkedList<String[]> data = new LinkedList<String[]>();
        this.connect();
        if (this.handler != null) {
            ResultSet resultSet = this.handler.query(this.getQueryString());
            int counter = 0;
            while (resultSet.next() && counter < 10) {
                String[] row = new String[usedAttributeNames.length];
                int c = 0;
                while (c < row.length) {
                    row[c] = resultSet.getString(c + 1);
                    ++c;
                }
                data.add(row);
                ++counter;
            }
            resultSet.close();
        }
        this.disconnect();
        this.dataView.update(usedAttributeNames, data, this.attributeTypeMap);
    }

    private void appendAttributeName(StringBuffer result, Object o, boolean first, boolean singleTable) {
        if (!first) {
            result.append(", ");
        }
        String attributeName = (String)o;
        if (singleTable) {
            result.append(this.createAttributeName(attributeName, singleTable));
        } else {
            result.append(String.valueOf(attributeName) + " AS " + this.createAttributeName(attributeName, singleTable));
        }
    }

    private void updateSQLQuery() {
        int n;
        Object[] objectArray;
        boolean first;
        Object[] tableSelection = this.tableList.getSelectedValues();
        if (tableSelection.length == 0) {
            this.sqlQueryTextArea.setText("");
            return;
        }
        boolean singleTable = tableSelection.length == 1;
        StringBuffer result = new StringBuffer("SELECT ");
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        if (singleTable && (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize())) {
            result.append("*");
        } else if (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize()) {
            first = true;
            int i = 0;
            while (i < this.attributeList.getModel().getSize()) {
                Object o = this.attributeList.getModel().getElementAt(i);
                this.appendAttributeName(result, o, first, singleTable);
                first = false;
                ++i;
            }
        } else {
            first = true;
            objectArray = attributeSelection;
            int n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.appendAttributeName(result, o, first, singleTable);
                first = false;
                ++n2;
            }
        }
        result.append(String.valueOf(Tools.getLineSeparator()) + "FROM ");
        first = true;
        objectArray = tableSelection;
        int n3 = 0;
        n = objectArray.length;
        while (n3 < n) {
            Object o = objectArray[n3];
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            String tableName = (String)o;
            result.append(tableName);
            ++n3;
        }
        String whereText = this.whereTextArea.getText().trim();
        if (whereText.length() > 0) {
            result.append(String.valueOf(Tools.getLineSeparator()) + "WHERE " + whereText);
        }
        this.sqlQueryTextArea.setText(result.toString());
    }

    private String getQueryString() {
        String result = this.sqlQueryTextArea.getText().trim();
        result = result.replaceAll(Tools.getLineSeparator(), " ");
        return result;
    }

    private void showConnectionError(String message, SQLException e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + "Connection to database has failed:" + Tools.getLineSeparator() + e.getMessage().substring(0, Math.min(300, e.getMessage().length())) + "...", "Connection failed", 0);
    }

    protected void finish(ConfigurationListener listener) {
        try {
            this.disconnect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String sqlQueryString = this.getQueryString();
        String databaseURL = this.urlField.getText().trim();
        String userName = this.userNameField.getText().trim();
        if (databaseURL.length() == 0 || sqlQueryString.length() == 0 || userName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("You must specify a database connection and proper settings - the operator will not work without this." + Tools.getLineSeparator() + "Please select \"Cancel\" if you want to abort this wizard.");
        } else {
            Parameters parameters = listener.getParameters();
            parameters.setParameter("work_on_database", "false");
            parameters.setParameter("database_url", databaseURL);
            parameters.setParameter("username", userName);
            parameters.setParameterWithoutCheck("password", null);
            if (this.passwordFromTextField) {
                parameters.setParameter("password", new String(this.passwordField.getPassword()));
            }
            parameters.setParameter("query", sqlQueryString);
            parameters.setParameterWithoutCheck("query_file", null);
            parameters.setParameterWithoutCheck("table_name", null);
            parameters.setParameterWithoutCheck("label_attribute", null);
            parameters.setParameterWithoutCheck("id_attribute", null);
            parameters.setParameterWithoutCheck("weight_attribute", null);
            int i = 1;
            while (i < Attributes.KNOWN_ATTRIBUTE_TYPES.length) {
                this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
                ++i;
            }
            boolean singleTable = this.tableList.getSelectedValues().length == 1;
            for (String attName : this.attributeTypeMap.keySet()) {
                String attType = this.attributeTypeMap.get(attName);
                String maskedAttributeName = this.createAttributeName(attName, singleTable);
                if (attType.equals("label")) {
                    parameters.setParameter("label_attribute", maskedAttributeName);
                    continue;
                }
                if (attType.equals("id")) {
                    parameters.setParameter("id_attribute", maskedAttributeName);
                    continue;
                }
                if (!attType.equals("weight")) continue;
                parameters.setParameter("weight_attribute", maskedAttributeName);
            }
            listener.setParameters(parameters);
            this.dispose();
            YaleGUI.getMainFrame().getPropertyTable().refresh();
        }
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<String> columns = new LinkedList<String>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<String> i = this.attributeTypeMap.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            String attName = i.next();
            String attType = this.attributeTypeMap.get(attName);
            if (attType.equals(type)) {
                columns.add(attName);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            columns.toArray(names);
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, String.valueOf(type) + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                for (String name : columns) {
                    if (name.equals(selection)) continue;
                    this.attributeTypeMap.remove(name);
                    this.attributeTypeMap.put(name, "attribute");
                }
            }
        }
    }

    private String createAttributeName(String attributeName, boolean singleTable) {
        String[] nameParts = attributeName.split("\\.");
        if (nameParts.length == 1) {
            return attributeName;
        }
        if (singleTable) {
            return nameParts[1];
        }
        return String.valueOf(nameParts[0]) + "__" + nameParts[1];
    }

    protected void cancel() {
        try {
            this.disconnect();
        }
        catch (SQLException e) {
            LogService.logMessage("Problem during disconnecting: " + e.getMessage(), 4);
        }
        super.cancel();
    }

    public void createConfigurationWizard(ConfigurationListener listener) {
        new DBExampleSourceConfigurationWizard(listener).setVisible(true);
    }
}

