/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.tools.Ontology;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class MetaDataViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1598719681189990076L;
    public static final int TYPE = 0;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int SOURCE = 3;
    public static final int VALUE_TYPE = 4;
    public static final int BLOCK_TYPE = 5;
    public static final int STATISTICS = 6;
    public static final String[] COLUMN_NAMES = new String[]{"Type", "Index", "Name", "Construction", "Value Type", "Block Type", "Statistics"};
    private static final String[] COLUMN_TOOL_TIPS = new String[]{"The type of the attribute (regular or one of the special types).", "The index of the attribute in the example table backing up this example set (view).", "The name of the attribute.", "The construction source of the attribute, i.e. how it was generated.", "The value type of this attribute, e.g. if the attribute is nominal or numerical.", "The block type of this attribute, e.g. if the attribute is a single attribute or part of a series.", "Statistics about the data set values with respect to this attribute."};
    private int[] currentMapping;
    private ExampleSet exampleSet;
    private Attribute[] regularAttributes;
    private Attribute[] specialAttributes;
    private String[] specialAttributeNames;

    public MetaDataViewerTableModel(ExampleSet exampleSet) {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        this.currentMapping = nArray;
        this.exampleSet = exampleSet;
        this.regularAttributes = Tools.createRegularAttributeArray(exampleSet);
        this.specialAttributes = new Attribute[exampleSet.getAttributes().specialSize()];
        this.specialAttributeNames = new String[exampleSet.getAttributes().specialSize()];
        Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
        int counter = 0;
        while (i.hasNext()) {
            AttributeRole role = i.next();
            this.specialAttributeNames[counter] = role.getSpecialName();
            this.specialAttributes[counter] = role.getAttribute();
            ++counter;
        }
    }

    public void setShowColumn(int index, boolean show) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            if (i == index) {
                if (show) {
                    result.add(i);
                }
            } else if (this.getShowColumn(i)) {
                result.add(i);
            }
            ++i;
        }
        this.currentMapping = new int[result.size()];
        Iterator i2 = result.iterator();
        int counter = 0;
        while (i2.hasNext()) {
            this.currentMapping[counter++] = (Integer)i2.next();
        }
        this.fireTableStructureChanged();
    }

    public boolean getShowColumn(int index) {
        int i = 0;
        while (i < this.currentMapping.length) {
            if (this.currentMapping[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getRowCount() {
        return this.exampleSet.getAttributes().specialSize() + this.exampleSet.getAttributes().size();
    }

    public int getColumnCount() {
        return this.currentMapping.length;
    }

    public Object getValueAt(int row, int col) {
        Attribute attribute = null;
        String type = "regular";
        if (row < this.specialAttributes.length) {
            attribute = this.specialAttributes[row];
            type = this.specialAttributeNames[row];
        } else {
            attribute = this.regularAttributes[row - this.specialAttributes.length];
        }
        int actualColumn = this.currentMapping[col];
        switch (actualColumn) {
            case 0: {
                return type;
            }
            case 1: {
                return attribute.getTableIndex();
            }
            case 2: {
                return attribute.getName();
            }
            case 3: {
                return attribute.getConstruction();
            }
            case 4: {
                return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType());
            }
            case 5: {
                return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType());
            }
            case 6: {
                return attribute.getStatistics().getDescription();
            }
        }
        return "unknown";
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[this.currentMapping[col]];
    }

    public String getToolTip(int column) {
        if (column < 0 || column >= this.currentMapping.length) {
            return "";
        }
        return COLUMN_TOOL_TIPS[this.currentMapping[column]];
    }
}

