/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.TableSorter;
import edu.udo.cs.yale.gui.viewer.MetaDataViewerTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class MetaDataViewerTable
extends ExtendedJTable {
    private static final long serialVersionUID = -4879028136543294746L;
    private int numberOfSpecialAttributeRows = 0;
    private MetaDataViewerTableModel model = null;

    public void setExampleSet(ExampleSet exampleSet) {
        this.model = new MetaDataViewerTableModel(exampleSet);
        this.setModel(this.model);
        this.numberOfSpecialAttributeRows = exampleSet.getAttributes().specialSize();
        TableColumn lastColumn = this.getColumnModel().getColumn(this.getModel().getColumnCount() - 1);
        lastColumn.setPreferredWidth(600);
    }

    public MetaDataViewerTableModel getMetaDataModel() {
        return this.model;
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        return this.model.getToolTip(realColumnIndex);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = MetaDataViewerTable.this.convertColumnIndexToModel(index);
                return MetaDataViewerTable.this.model.getToolTip(realColumnIndex);
            }
        };
    }

    public Color getCellColor(int row, int col) {
        int actualRowIndex = ((TableSorter)this.getModel()).modelIndex(row);
        if (actualRowIndex < this.numberOfSpecialAttributeRows) {
            return SwingTools.LIGHTEST_YELLOW;
        }
        if (row % 2 == 0) {
            return Color.WHITE;
        }
        return SwingTools.LIGHTEST_BLUE;
    }
}

