/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.viewer.MetaDataViewerTable;
import edu.udo.cs.yale.gui.viewer.MetaDataViewerTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class MetaDataViewer
extends JPanel {
    private static final String MENU_ICON_NAME = "icons/24/navigate_close.png";
    private static Icon menuIcon = null;
    private static final long serialVersionUID = 5466205420267797125L;
    private JLabel generalInfo = new JLabel();
    private MetaDataViewerTable metaDataTable = new MetaDataViewerTable();

    static {
        menuIcon = SwingTools.createIcon(MENU_ICON_NAME);
    }

    public MetaDataViewer(ExampleSet exampleSet) {
        super(new BorderLayout());
        JPanel infoPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        infoPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(this.generalInfo, c);
        infoPanel.add(this.generalInfo);
        final JButton optionMenuButton = menuIcon != null ? new JButton("", menuIcon){
            private static final long serialVersionUID = 5070388716887885349L;

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 24;
                return dim;
            }
        } : new JButton("Menu");
        optionMenuButton.setToolTipText("Shows additional options for this view.");
        optionMenuButton.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                int i = 0;
                while (i < MetaDataViewerTableModel.COLUMN_NAMES.length) {
                    menu.add(new ToggleShowColumnItem(MetaDataViewerTableModel.COLUMN_NAMES[i], i, MetaDataViewer.this.metaDataTable.getMetaDataModel().getShowColumn(i), MetaDataViewer.this.metaDataTable));
                    ++i;
                }
                menu.show(optionMenuButton, e.getX(), e.getY());
            }
        });
        JPanel optionButtonPanel = new JPanel(new FlowLayout(2));
        optionButtonPanel.add(optionMenuButton);
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(optionButtonPanel, c);
        infoPanel.add(optionButtonPanel);
        this.add((Component)infoPanel, "North");
        JScrollPane tableScrollPane = new JScrollPane(this.metaDataTable);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        exampleSet.recalculateAllAttributeStatistics();
        StringBuffer infoText = new StringBuffer("ExampleSet (");
        int noExamples = exampleSet.size();
        infoText.append(noExamples);
        infoText.append(noExamples == 1 ? " example, " : " examples, ");
        int noSpecial = exampleSet.getAttributes().specialSize();
        infoText.append(noSpecial);
        infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
        int noRegular = exampleSet.getAttributes().size();
        infoText.append(noRegular);
        infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
        this.generalInfo.setText(infoText.toString());
        this.metaDataTable.setExampleSet(exampleSet);
    }

    private static class ToggleShowColumnItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 570766967933245379L;
        private int index;
        private MetaDataViewerTable metaDataTable;

        ToggleShowColumnItem(String name, int index, boolean state, MetaDataViewerTable metaDataTable) {
            super("Show column '" + name + "'", state);
            this.setToolTipText("Toggles if the column with name '" + name + "' should be displayed");
            this.addActionListener(this);
            this.index = index;
            this.metaDataTable = metaDataTable;
        }

        public void actionPerformed(ActionEvent e) {
            this.metaDataTable.getMetaDataModel().setShowColumn(this.index, this.isSelected());
            TableColumn lastColumn = this.metaDataTable.getColumnModel().getColumn(this.metaDataTable.getModel().getColumnCount() - 1);
            lastColumn.setPreferredWidth(600);
        }
    }
}

