/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3057324874942971672L;
    private Attribute[] regularAttributes;
    private Attribute[] specialAttributes;
    private ExampleSet exampleSet;

    public DataViewerTableModel(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.regularAttributes = new Attribute[exampleSet.getAttributes().size()];
        Iterator<Attribute> r = exampleSet.getAttributes().iterator();
        int counter = 0;
        while (r.hasNext()) {
            this.regularAttributes[counter++] = r.next();
        }
        this.specialAttributes = new Attribute[exampleSet.getAttributes().specialSize()];
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        counter = 0;
        while (s.hasNext()) {
            this.specialAttributes[counter++] = s.next().getAttribute();
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return Integer.class;
        }
        int col = column - 1;
        Attribute attribute = null;
        attribute = col < this.specialAttributes.length ? this.specialAttributes[col] : this.regularAttributes[col - this.specialAttributes.length];
        if (!attribute.isNominal()) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.exampleSet.size();
    }

    @Override
    public int getColumnCount() {
        return this.specialAttributes.length + this.regularAttributes.length + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return row + 1;
        }
        int col = column - 1;
        Example example = this.exampleSet.getExample(row);
        if (example != null) {
            if (col < this.specialAttributes.length) {
                return this.getValueWithCorrectClass(example, this.specialAttributes[col]);
            }
            return this.getValueWithCorrectClass(example, this.regularAttributes[col - this.specialAttributes.length]);
        }
        return null;
    }

    private Object getValueWithCorrectClass(Example example, Attribute attribute) {
        if (!attribute.isNominal()) {
            return new Double(example.getValue(attribute));
        }
        return example.getValueAsString(attribute);
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0) {
            return "";
        }
        if (column == 0) {
            return "row no.";
        }
        int col = column - 1;
        if (col < this.specialAttributes.length) {
            return this.specialAttributes[col].getName();
        }
        return this.regularAttributes[col - this.specialAttributes.length].getName();
    }
}

