/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.viewer.DataViewerTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

public class DataViewerTable
extends ExtendedJTable {
    private static final long serialVersionUID = 5535239693801265693L;
    private int numberOfSpecialAttributes = 0;

    public DataViewerTable() {
        this.setAutoResizeMode(0);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.setModel(new DataViewerTableModel(exampleSet));
        this.numberOfSpecialAttributes = exampleSet.getAttributes().specialSize();
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        return this.getToolTipText(realColumnIndex);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = DataViewerTable.this.convertColumnIndexToModel(index);
                return DataViewerTable.this.getToolTipText(realColumnIndex);
            }
        };
    }

    private String getToolTipText(int realColumnIndex) {
        if (realColumnIndex == 0) {
            return "The position of the example in the (filtered) view on the example table.";
        }
        return "The data for the attribute '" + this.getModel().getColumnName(realColumnIndex) + "'.";
    }

    public Color getCellColor(int row, int col) {
        if (col > 0 && col < this.numberOfSpecialAttributes + 1) {
            if (row % 2 == 0) {
                return Color.WHITE;
            }
            return SwingTools.LIGHTEST_YELLOW;
        }
        if (row % 2 == 0) {
            return Color.WHITE;
        }
        return SwingTools.LIGHTEST_BLUE;
    }
}

