/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.ConditionedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.viewer.DataViewerTable;
import edu.udo.cs.yale.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DataViewer
extends JPanel {
    private static final long serialVersionUID = -8114228636932871865L;
    private JLabel generalInfo = new JLabel();
    private DataViewerTable dataTable = new DataViewerTable();
    private JLabel filterCounter = new JLabel();
    private transient ExampleSet originalExampleSet;

    public DataViewer(ExampleSet exampleSet) {
        super(new BorderLayout());
        this.originalExampleSet = exampleSet;
        JPanel infoPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        infoPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        StringBuffer infoText = new StringBuffer("ExampleSet (");
        int noExamples = this.originalExampleSet.size();
        infoText.append(noExamples);
        infoText.append(noExamples == 1 ? " example, " : " examples, ");
        int noSpecial = this.originalExampleSet.getAttributes().specialSize();
        infoText.append(noSpecial);
        infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
        int noRegular = this.originalExampleSet.getAttributes().size();
        infoText.append(noRegular);
        infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
        this.generalInfo.setText(infoText.toString());
        layout.setConstraints(this.generalInfo, c);
        infoPanel.add(this.generalInfo);
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        filterPanel.add(new JLabel("View Filter "));
        this.updateFilterCounter(this.originalExampleSet);
        filterPanel.add(this.filterCounter);
        LinkedList<String> applicableFilterNames = new LinkedList<String>();
        int i = 0;
        while (i < ConditionExampleReader.KNOWN_CONDITION_NAMES.length) {
            String conditionName = ConditionExampleReader.KNOWN_CONDITION_NAMES[i];
            try {
                ConditionExampleReader.createCondition(conditionName, exampleSet, null);
                applicableFilterNames.add(conditionName);
            }
            catch (ConditionCreationException conditionCreationException) {
                // empty catch block
            }
            ++i;
        }
        String[] applicableConditions = new String[applicableFilterNames.size()];
        applicableFilterNames.toArray(applicableConditions);
        final JComboBox<String> filterSelector = new JComboBox<String>(applicableConditions);
        filterSelector.setToolTipText("These filters can be used to skip examples in the view fulfilling the filter condition.");
        filterSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataViewer.this.updateFilter((String)filterSelector.getSelectedItem());
            }
        });
        filterPanel.add(filterSelector);
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(filterPanel, c);
        infoPanel.add(filterPanel);
        this.add((Component)infoPanel, "North");
        JScrollPane tableScrollPane = new JScrollPane(this.dataTable);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.dataTable.setExampleSet(exampleSet);
    }

    private void updateFilter(String conditionName) {
        ExampleSet filteredExampleSet = this.originalExampleSet;
        try {
            Condition condition = ConditionExampleReader.createCondition(conditionName, this.originalExampleSet, null);
            filteredExampleSet = new ConditionedExampleSet(this.originalExampleSet, condition);
        }
        catch (ConditionCreationException ex) {
            LogService.logMessage("Cannot create condition '" + conditionName + "' for filtered data view: " + ex.getMessage(), 6);
            filteredExampleSet = this.originalExampleSet;
        }
        this.updateFilterCounter(filteredExampleSet);
        this.setExampleSet(filteredExampleSet);
    }

    private void updateFilterCounter(ExampleSet filteredExampleSet) {
        this.filterCounter.setText("(" + filteredExampleSet.size() + " / " + this.originalExampleSet.size() + "): ");
    }
}

