/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.viewer.DataTableViewerTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

public class DataTableViewerTable
extends ExtendedJTable {
    private static final long serialVersionUID = 3206734427933036268L;
    public static final int ALTERNATING = 0;
    public static final int SCALED = 1;
    public static final int ABS_SCALED = 2;
    private int rendererType = 0;
    private double min = 0.0;
    private double max = 0.0;

    public DataTableViewerTable() {
        this.setAutoResizeMode(0);
    }

    public void setDataTable(DataTable dataTable) {
        this.setModel(new DataTableViewerTableModel(dataTable));
        if (this.rendererType != 0) {
            this.recalculateStatistics();
        }
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
        if (rendererType != 0) {
            this.recalculateStatistics();
        }
    }

    private void recalculateStatistics() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        int x = 0;
        while (x < this.getRowCount()) {
            int y = 0;
            while (y < this.getColumnCount()) {
                Object valueObject = this.getValueAt(x, y);
                double value = Double.NaN;
                try {
                    value = Double.parseDouble(valueObject.toString());
                    if (this.rendererType == 2) {
                        value = Math.abs(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!Double.isNaN(value)) {
                    this.min = Math.min(this.min, value);
                    this.max = Math.max(this.max, value);
                }
                ++y;
            }
            ++x;
        }
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        if (realColumnIndex >= 0 && realColumnIndex < this.getModel().getColumnCount()) {
            return "The column " + this.getModel().getColumnName(realColumnIndex);
        }
        return "";
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = DataTableViewerTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex >= 0 && realColumnIndex < DataTableViewerTable.this.getModel().getColumnCount()) {
                    return "The column " + DataTableViewerTable.this.getModel().getColumnName(realColumnIndex);
                }
                return "";
            }
        };
    }

    public Color getCellColor(int row, int col) {
        switch (this.rendererType) {
            case 0: {
                if (row % 2 == 0) {
                    return Color.WHITE;
                }
                return SwingTools.LIGHTEST_BLUE;
            }
        }
        Object valueObject = this.getValueAt(row, col);
        try {
            double value = Double.parseDouble(valueObject.toString());
            if (this.rendererType == 2) {
                value = Math.abs(value);
            }
            float scaled = (float)((value - this.min) / (this.max - this.min));
            Color color = new Color(1.0f - scaled * 0.2f, 1.0f - scaled * 0.2f, 1.0f);
            return color;
        }
        catch (NumberFormatException e) {
            return Color.WHITE;
        }
    }
}

