/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.viewer;

import edu.udo.cs.yale.tools.Tools;
import javax.swing.table.AbstractTableModel;

public class ConfusionMatrixViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1206988933244249851L;
    private String[] classNames;
    private int[][] counter;
    private int[] rowSums;
    private int[] columnSums;

    public ConfusionMatrixViewerTableModel(String[] classNames, int[][] counter) {
        this.classNames = classNames;
        this.counter = counter;
        this.rowSums = new int[classNames.length];
        this.columnSums = new int[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            int j = 0;
            while (j < classNames.length) {
                int n = i;
                this.columnSums[n] = this.columnSums[n] + counter[i][j];
                int n2 = i;
                this.rowSums[n2] = this.rowSums[n2] + counter[j][i];
                ++j;
            }
            ++i;
        }
    }

    public int getRowCount() {
        return this.classNames.length + 2;
    }

    public int getColumnCount() {
        return this.classNames.length + 2;
    }

    public Object getValueAt(int row, int col) {
        if (row == 0) {
            if (col == 0) {
                return "";
            }
            if (col == this.getColumnCount() - 1) {
                return "class precision";
            }
            return "true " + this.classNames[col - 1];
        }
        if (row == this.getRowCount() - 1) {
            if (col == 0) {
                return "class recall";
            }
            if (col == this.getColumnCount() - 1) {
                return "";
            }
            double recall = (double)this.counter[col - 1][col - 1] / (double)this.columnSums[col - 1];
            return Tools.formatPercent(recall);
        }
        if (col == 0) {
            return "pred. " + this.classNames[row - 1];
        }
        if (col == this.getColumnCount() - 1) {
            double precision = (double)this.counter[row - 1][row - 1] / (double)this.rowSums[row - 1];
            return Tools.formatPercent(precision);
        }
        return this.counter[col - 1][row - 1];
    }
}

