/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.dialog.ErrorDialog;
import edu.udo.cs.yale.gui.tools.SimpleFileFilter;
import edu.udo.cs.yale.gui.tools.syntax.SyntaxStyle;
import edu.udo.cs.yale.gui.tools.syntax.SyntaxUtilities;
import edu.udo.cs.yale.gui.tools.syntax.TextAreaDefaults;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class SwingTools {
    private static final int TOOL_TIP_LINE_LENGTH = 100;
    public static final int TABLE_ROW_EXTRA_HEIGHT = 4;
    public static final int TABLE_WITH_COMPONENTS_ROW_EXTRA_HEIGHT = 10;
    public static final Color DARKEST_YELLOW = new Color(190, 170, 100);
    public static final Color DARK_YELLOW = new Color(220, 200, 130);
    public static final Color LIGHT_YELLOW = new Color(230, 215, 155);
    public static final Color LIGHTEST_YELLOW = new Color(250, 240, 190);
    public static final Color DARKEST_BLUE = new Color(110, 130, 170);
    public static final Color DARK_BLUE = new Color(140, 160, 200);
    public static final Color LIGHT_BLUE = new Color(196, 213, 255);
    public static final Color LIGHTEST_BLUE = new Color(232, 239, 255);
    public static final Color LIGHTEST_RED = new Color(255, 195, 195);

    public static GradientPaint makeBluePaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_BLUE, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_BLUE, true);
    }

    public static GradientPaint makeYellowPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_YELLOW, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_YELLOW, true);
    }

    public static ImageIcon createIcon(String resourceName) {
        URL url = Tools.getResource(resourceName);
        if (url != null) {
            return new ImageIcon(url);
        }
        LogService.logMessage("Cannot load image '" + resourceName + "': icon will not be displayed", 4);
        return null;
    }

    public static String transformToolTipText(String description) {
        String[] lines;
        String completeText = description.trim();
        StringBuffer result = new StringBuffer("<html>");
        completeText = Tools.transformAllLineSeparators(completeText);
        String[] stringArray = lines = completeText.split("\n");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String text = stringArray[n];
            boolean first = true;
            while (text.length() > 100) {
                int spaceIndex = text.indexOf(" ", 100);
                if (!first) {
                    result.append("<br>");
                }
                first = false;
                if (spaceIndex >= 0) {
                    result.append(text.substring(0, spaceIndex));
                    text = text.substring(spaceIndex + 1);
                    continue;
                }
                result.append(text);
                text = "";
            }
            if (!first && text.length() > 0) {
                result.append("<br>");
            }
            result.append(text);
            result.append("<br>");
            ++n;
        }
        result.append("</html>");
        return result.toString();
    }

    public static String getStringFromClassArray(Class[] classes) {
        String outputString = "";
        if (classes == null) {
            outputString = "none";
        } else {
            int i = 0;
            while (i < classes.length) {
                if (i != 0) {
                    outputString = String.valueOf(outputString) + ", ";
                }
                outputString = String.valueOf(outputString) + Tools.classNameWOPackage(classes[i]);
                ++i;
            }
        }
        if (outputString.length() == 0) {
            outputString = "none";
        }
        return outputString;
    }

    public static void showVerySimpleErrorMessage(String message) {
        JOptionPane.showMessageDialog(YaleGUI.getMainFrame(), message, "Exception", 0);
    }

    public static void showSimpleErrorMessage(String message, Throwable e) {
        JOptionPane.showMessageDialog(YaleGUI.getMainFrame(), String.valueOf(message) + Tools.getLineSeparator() + Tools.classNameWOPackage(e.getClass()) + " caught:" + Tools.getLineSeparator() + e.getMessage(), "Exception", 0);
    }

    public static void showErrorMessage(String message, Throwable e) {
        ErrorDialog dialog = ErrorDialog.create(message, e);
        dialog.setLocationRelativeTo(YaleGUI.getMainFrame());
        dialog.setVisible(true);
    }

    public static File chooseFile(Component parent, File file, boolean open, String extension, String extensionDescription) {
        return SwingTools.chooseFile(parent, file, open, false, extension, extensionDescription);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String extension, String extensionDescription) {
        String[] stringArray;
        String[] stringArray2;
        if (extension == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = extension;
        }
        if (extensionDescription == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = extensionDescription;
        }
        return SwingTools.chooseFile(parent, file, open, onlyDirs, stringArray2, stringArray);
    }

    private static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String[] extensions, String[] extensionDescriptions) {
        FileFilter[] filters = null;
        if (extensions != null) {
            filters = new FileFilter[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                filters[i] = new SimpleFileFilter(String.valueOf(extensionDescriptions[i]) + " (*." + extensions[i] + ")", "." + extensions[i]);
                ++i;
            }
        }
        return SwingTools.chooseFile(parent, file, open, onlyDirs, filters);
    }

    private static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, FileFilter[] fileFilters) {
        if (parent == null) {
            parent = YaleGUI.getMainFrame();
        }
        JFileChooser fileChooser = SwingTools.createFileChooser(file, onlyDirs, fileFilters);
        int returnValue = open ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        switch (returnValue) {
            case 0: {
                File selectedFile = fileChooser.getSelectedFile();
                FileFilter selectedFilter = fileChooser.getFileFilter();
                String extension = null;
                if (selectedFilter instanceof SimpleFileFilter) {
                    SimpleFileFilter simpleFF = (SimpleFileFilter)selectedFilter;
                    extension = simpleFF.getExtension();
                }
                if (extension != null && !selectedFile.getAbsolutePath().endsWith(extension)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + extension);
                }
                return selectedFile;
            }
        }
        return null;
    }

    public static JFileChooser createFileChooser(File file, boolean onlyDirs, FileFilter[] fileFilters) {
        File directory = null;
        if (file != null) {
            directory = file.isDirectory() ? file : file.getAbsoluteFile().getParentFile();
        } else {
            File experimentFile = YaleGUI.getMainFrame().getExperiment() != null ? YaleGUI.getMainFrame().getExperiment().getExperimentFile() : null;
            directory = experimentFile != null ? experimentFile.getAbsoluteFile().getParentFile() : new File(System.getProperty("user.dir"));
        }
        JFileChooser fileChooser = new JFileChooser(directory);
        if (onlyDirs) {
            fileChooser.setFileSelectionMode(1);
        }
        if (fileFilters != null) {
            fileChooser.setAcceptAllFileFilterUsed(true);
            int i = 0;
            while (i < fileFilters.length) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
                ++i;
            }
        }
        if (file != null) {
            fileChooser.setSelectedFile(file);
        }
        try {
            Class<?> configurationClazz = Class.forName("com.Trendy.swing.plaf.TrendyConfiguration");
            Field favouritesField = configurationClazz.getField("FILECHOOSER_FAVOURITES");
            String favouritesString = (String)favouritesField.get(null);
            fileChooser.putClientProperty(favouritesString, Boolean.TRUE);
            Field viewField = configurationClazz.getField("FILECHOOSER_VIEW");
            String viewString = (String)viewField.get(null);
            Field detailsField = configurationClazz.getField("FILECHOOSER_VIEW_DETAILS");
            String detailsString = (String)detailsField.get(null);
            fileChooser.putClientProperty(viewString, detailsString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileChooser;
    }

    public static JPanel createTextPanel(String title, String text) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("<html><h2>" + title + "</h2><p>" + text + "</p></html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        panel.add((Component)label, "North");
        return panel;
    }

    public static String html2YaleText(String html) {
        if (html == null) {
            return null;
        }
        String result = html.replaceAll("<", "#ylt#");
        result = result.replaceAll(">", "#ygt#");
        result = result.replaceAll("\"", "#yquot#");
        result = result.replaceAll(Tools.getLineSeparator(), "");
        return result;
    }

    public static String text2DisplayHtml(String text) {
        String result = "<html><head><style type=text/css>body { font-family:sans-serif; font-size:12pt; }</style></head><body>" + text + "</body></html>";
        result = SwingTools.text2SimpleHtml(result);
        result = result.replaceAll("#yquot#", "&quot;");
        while (result.indexOf("<icon>") != -1) {
            int startIndex = result.indexOf("<icon>");
            int endIndex = result.indexOf("</icon>");
            String start = result.substring(0, startIndex);
            String end = result.substring(endIndex + 7);
            String icon = result.substring(startIndex + 6, endIndex).trim().toLowerCase();
            URL url = Tools.getResource("icons/" + icon + ".png");
            result = url != null ? String.valueOf(start) + "<img src=\"" + url + "\">" + end : String.valueOf(start) + end;
        }
        return result;
    }

    public static String text2SimpleHtml(String htmlText) {
        if (htmlText == null) {
            return null;
        }
        String replaceString = htmlText.replaceAll("#ygt#", ">");
        replaceString = replaceString.replaceAll("#ylt#", "<");
        StringBuffer result = new StringBuffer();
        boolean afterClose = true;
        int currentLineLength = 0;
        int i = 0;
        while (i < replaceString.length()) {
            char c = replaceString.charAt(i);
            if (!afterClose || c != ' ') {
                if (c == '<' && !afterClose) {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                }
                afterClose = false;
                result.append(c);
                if (++currentLineLength > 70 && c == ' ') {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                }
                if (c == '>') {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                    afterClose = true;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static Color getPointColor(double value) {
        return new Color(Color.HSBtoRGB((float)(0.68 * (1.0 - value)), 1.0f, 1.0f));
    }

    public static Color getPointColor(double value, double max, double min) {
        value = (value - min) / (max - min);
        return SwingTools.getPointColor(value);
    }

    public static TextAreaDefaults getTextAreaDefaults() {
        TextAreaDefaults defaults = TextAreaDefaults.getDefaults();
        defaults.styles = SwingTools.getSyntaxStyles();
        return defaults;
    }

    public static SyntaxStyle[] getSyntaxStyles() {
        SyntaxStyle[] styles = SyntaxUtilities.getDefaultSyntaxStyles();
        styles[1] = new SyntaxStyle(new Color(0x990033), true, false);
        styles[2] = new SyntaxStyle(Color.black, true, false);
        styles[6] = new SyntaxStyle(Color.black, false, true);
        styles[7] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[8] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[3] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[4] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }
}

