/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements BreakpointListener,
ExperimentListener {
    private static final String INACTIVE_ICON_NAME = "icons/24/bullet_ball_glass_grey.png";
    private static final String RUNNING_ICON_NAME = "icons/24/bullet_ball_glass_green.png";
    private static final String STOPPED_ICON_NAME = "icons/24/bullet_ball_glass_red.png";
    private static Icon inactiveIcon = null;
    private static Icon runningIcon = null;
    private static Icon stoppedIcon = null;
    private static final long serialVersionUID = 1189363377612273467L;
    private JLabel clock = StatusBar.createLabel(StatusBar.getTime(), true);
    private JLabel operator = StatusBar.createLabel("                         ", false);
    private transient Operator currentOperator = null;
    private JLabel trafficLightLabel = new JLabel();
    private int breakpoint = -1;
    private String specialText = null;

    static {
        inactiveIcon = SwingTools.createIcon(INACTIVE_ICON_NAME);
        runningIcon = SwingTools.createIcon(RUNNING_ICON_NAME);
        stoppedIcon = SwingTools.createIcon(STOPPED_ICON_NAME);
    }

    public StatusBar() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        this.trafficLightLabel.setIcon(inactiveIcon);
        this.trafficLightLabel.setToolTipText("Indicates the current running state.");
        constraints.weightx = 0.0;
        layout.setConstraints(this.trafficLightLabel, constraints);
        this.add(this.trafficLightLabel);
        constraints.weightx = 1.0;
        constraints.gridwidth = -1;
        layout.setConstraints(this.operator, constraints);
        this.add(this.operator);
        this.clock.setToolTipText("The current system time.");
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        layout.setConstraints(this.clock, constraints);
        this.add(this.clock);
    }

    public void startClockThread() {
        new Thread(){

            public void run() {
                this.setPriority(1);
                try {
                    while (true) {
                        StatusBar.this.clock.setText(StatusBar.getTime());
                        if (StatusBar.this.specialText != null) {
                            StatusBar.this.setText(StatusBar.this.specialText);
                        } else if (StatusBar.this.currentOperator != null) {
                            long execTime = System.currentTimeMillis() - StatusBar.this.currentOperator.getStartTime();
                            if (execTime > 1000L && StatusBar.this.breakpoint < 0) {
                                StatusBar.this.setText("[" + StatusBar.this.currentOperator.getApplyCount() + "] " + StatusBar.this.currentOperator.getName() + "  " + execTime / 1000L + " s");
                            }
                        } else {
                            StatusBar.this.setText("");
                        }
                        1.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    private static Border createBorder() {
        return new Border(){

            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Color highlight = c.getBackground().brighter().brighter();
                Color shadow = c.getBackground().darker().darker();
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(shadow);
                g.drawLine(3, 0, 3, h - 2);
                g.drawLine(3, 0, w - 3, 0);
                g.setColor(highlight);
                g.drawLine(3, h - 2, w - 3, h - 2);
                g.drawLine(w - 3, 1, w - 3, h - 2);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(1, 4, 2, 3);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    private static JLabel createLabel(String text, boolean border) {
        JLabel label = new JLabel(text);
        if (border) {
            label.setBorder(StatusBar.createBorder());
        }
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    private static String getTime() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public void breakpointReached(Operator op, IOContainer io, int location) {
        this.breakpoint = location;
        this.operator.setText("[" + op.getApplyCount() + "] " + op.getName() + ": breakpoint reached " + BreakpointListener.BREAKPOINT_POS_NAME[this.breakpoint] + " operator, press resume...");
        this.trafficLightLabel.setIcon(stoppedIcon);
    }

    public void resume() {
        this.breakpoint = -1;
        if (this.currentOperator != null) {
            this.setText();
        } else {
            this.operator.setText(" ");
        }
        this.trafficLightLabel.setIcon(runningIcon);
    }

    public void experimentStarts() {
        this.currentOperator = null;
        this.operator.setText("");
        this.specialText = null;
        this.trafficLightLabel.setIcon(runningIcon);
    }

    public void experimentStep(ExperimentOperator op) {
        this.currentOperator = op.getExperiment().getCurrentOperator();
        this.setText();
    }

    public void experimentEnded() {
        this.operator.setText("");
        this.currentOperator = null;
        this.specialText = null;
        this.trafficLightLabel.setIcon(inactiveIcon);
    }

    public void setSpecialText(String specialText) {
        this.specialText = specialText;
        this.setText(this.specialText);
    }

    public void clearSpecialText() {
        this.specialText = null;
        this.setText("");
    }

    private synchronized void setText(String text) {
        this.operator.setText(text);
    }

    private void setText() {
        this.setText("[" + this.currentOperator.getApplyCount() + "] " + this.currentOperator.getName());
    }
}

