/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class OperatorListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4236587258844548010L;
    private boolean coloredBackground;

    public OperatorListCellRenderer(boolean coloredBackground) {
        this.coloredBackground = coloredBackground;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OperatorDescription operatorDescription = (OperatorDescription)value;
        Component component = super.getListCellRendererComponent((JList<?>)list, operatorDescription.getName(), index, isSelected, cellHasFocus);
        JLabel label = (JLabel)component;
        try {
            label.setIcon(new ImageIcon(operatorDescription.getIcon()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.coloredBackground && !isSelected && index % 2 != 0) {
            label.setBackground(SwingTools.LIGHTEST_BLUE);
        }
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Operator operator = null;
        try {
            operator = operatorDescription.createOperatorInstance();
        }
        catch (OperatorCreationException e) {
            LogService.logMessage("Problem during creation of operator instance: " + e.getMessage(), 4);
        }
        StringBuffer toolTipText = new StringBuffer("<b>Description:</b> " + operatorDescription.getDescription());
        if (operator != null) {
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Input:</b> " + SwingTools.getStringFromClassArray(operator.getInputClasses()));
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Output:</b> " + SwingTools.getStringFromClassArray(operator.getOutputClasses()));
        }
        label.setToolTipText(SwingTools.transformToolTipText(toolTipText.toString()));
        return label;
    }
}

