/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.operatortree.TransferableOperator;
import edu.udo.cs.yale.gui.tools.OperatorListCellRenderer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Vector;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorList
extends JList
implements DragSourceListener,
DragGestureListener {
    private static final long serialVersionUID = 1L;
    private OperatorListCellRenderer operatorDialogCellRenderer;
    private DragSource dragSource;

    public OperatorList() {
        this(false, true);
    }

    public OperatorList(boolean horizontalWrap, boolean coloredCellBackgrounds) {
        this.operatorDialogCellRenderer = new OperatorListCellRenderer(coloredCellBackgrounds);
        if (horizontalWrap) {
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(-1);
        }
        this.setCellRenderer(this.operatorDialogCellRenderer);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setSelectionMode(0);
    }

    public void setOperatorDescriptions(Vector<OperatorDescription> descriptions) {
        this.setListData(descriptions);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (Integer.valueOf(e.getDragAction()) != 1) {
            return;
        }
        Point dragOrigin = e.getDragOrigin();
        int selectedIndex = this.locationToIndex(dragOrigin);
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
        OperatorDescription selectedListElement = (OperatorDescription)this.getSelectedValue();
        Operator selectedOperator = null;
        if (selectedListElement != null) {
            try {
                selectedOperator = selectedListElement.createOperatorInstance();
            }
            catch (OperatorCreationException ocE) {
                ocE.printStackTrace();
            }
            if (selectedOperator != null) {
                TransferableOperator selectedTransferableOperator = new TransferableOperator(selectedOperator);
                try {
                    e.startDrag(null, null, new Point(0, 0), selectedTransferableOperator, this);
                }
                catch (InvalidDnDOperationException dndE) {
                    dndE.printStackTrace();
                }
            }
        }
    }
}

