/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LoggingViewerOutputStream
extends OutputStream {
    private JTextPane textArea;
    private int currentLineLength = 0;
    private char lastChar = (char)65535;
    private SimpleAttributeSet attributeSet;
    private LinkedList<Integer> lineLengths = new LinkedList();
    private StringBuffer lastStyledText = new StringBuffer();

    public LoggingViewerOutputStream(JTextPane textArea) {
        this.attributeSet = new SimpleAttributeSet();
        this.textArea = textArea;
    }

    private void addTextToBuffer(String text) {
        this.lastStyledText.append(text);
    }

    private void addTextToViewer() {
        StyledDocument doc = this.textArea.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), this.lastStyledText.toString(), this.attributeSet);
        }
        catch (BadLocationException e) {
            SwingTools.showSimpleErrorMessage("Error during logging: ", e);
        }
        String maxRowsString = System.getProperty("yale.gui.messageviewer.rowlimit");
        int maxRows = 1000;
        try {
            if (maxRowsString != null) {
                maxRows = Integer.parseInt(maxRowsString);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Bad integer format for property '', using default number of maximum rows for logging (1000).", 4);
        }
        if (maxRows >= 0) {
            int removeLength = 0;
            while (this.lineLengths.size() > maxRows) {
                removeLength += this.lineLengths.removeFirst().intValue();
            }
            try {
                doc.remove(0, removeLength);
            }
            catch (BadLocationException e) {
                SwingTools.showSimpleErrorMessage("Error during logging: ", e);
            }
        }
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.lastStyledText = new StringBuffer();
    }

    public void write(int b) {
        char c = (char)b;
        switch (b) {
            case 10: 
            case 13: {
                if (this.lastChar != '\uffff') {
                    this.addTextToBuffer(Tools.getLineSeparator());
                    this.lineLengths.add(this.currentLineLength + Tools.getLineSeparator().length());
                    this.addTextToViewer();
                }
                this.lastChar = (char)65535;
                this.currentLineLength = 0;
                break;
            }
            case 9: {
                this.addTextToBuffer("    ");
                this.currentLineLength += "    ".length();
                break;
            }
            default: {
                if (this.lastChar == '$') {
                    this.addTextToViewer();
                    this.evaluateCommand("$" + c);
                } else if (this.lastChar == '^') {
                    this.addTextToViewer();
                    this.evaluateCommand("^" + c);
                } else if (c != '$' && c != '^') {
                    this.lastStyledText.append(c);
                    ++this.currentLineLength;
                }
                this.lastChar = c;
            }
        }
    }

    private void evaluateCommand(String style) {
        if (style.equals("$b")) {
            StyleConstants.setBold(this.attributeSet, true);
        } else if (style.equals("^b")) {
            StyleConstants.setBold(this.attributeSet, false);
        } else if (style.equals("$i")) {
            StyleConstants.setItalic(this.attributeSet, true);
        } else if (style.equals("^i")) {
            StyleConstants.setItalic(this.attributeSet, false);
        } else if (style.equals("$m")) {
            StyleConstants.setFontFamily(this.attributeSet, "monospaced");
        } else if (style.equals("^m")) {
            StyleConstants.setFontFamily(this.attributeSet, "sansserif");
        } else if (style.equals("$e")) {
            StyleConstants.setForeground(this.attributeSet, this.getHighlightingColor("yale.gui.messageviewer.highlight.errors", Color.RED));
        } else if (style.equals("^e")) {
            StyleConstants.setForeground(this.attributeSet, Color.BLACK);
        } else if (style.equals("$w")) {
            StyleConstants.setForeground(this.attributeSet, this.getHighlightingColor("yale.gui.messageviewer.highlight.warnings", Color.BLUE));
        } else if (style.equals("^w")) {
            StyleConstants.setForeground(this.attributeSet, Color.BLACK);
        }
    }

    public void clear() {
        this.lastChar = (char)65535;
        this.currentLineLength = 0;
        this.lineLengths.clear();
    }

    private Color getHighlightingColor(String propertyName, Color errorColor) {
        String propertyString = System.getProperty(propertyName);
        if (propertyString != null) {
            String[] colors = propertyString.split(",");
            Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            return color;
        }
        return errorColor;
    }
}

