/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.dialog.SearchDialog;
import edu.udo.cs.yale.gui.dialog.SearchableJTextComponent;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.LoggingViewerOutputStream;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.actions.ClearMessageAction;
import edu.udo.cs.yale.gui.tools.actions.LoggingSearchAction;
import edu.udo.cs.yale.gui.tools.actions.SaveLogFileAction;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class LoggingViewer
extends JScrollPane
implements MouseListener {
    private static final long serialVersionUID = 551259537624386372L;
    public transient LoggingViewerOutputStream outputStream;
    public final Action CLEAR_MESSAGE_VIEWER_ACTION_24 = new ClearMessageAction(this, IconSize.SMALL);
    public final Action CLEAR_MESSAGE_VIEWER_ACTION_32 = new ClearMessageAction(this, IconSize.MIDDLE);
    public final Action SAVE_LOGFILE_ACTION_24 = new SaveLogFileAction(this, IconSize.SMALL);
    public final Action SAVE_LOGFILE_ACTION_32 = new SaveLogFileAction(this, IconSize.MIDDLE);
    public final Action SEARCH_ACTION_24 = new LoggingSearchAction(this, IconSize.SMALL);
    public final Action SEARCH_ACTION_32 = new LoggingSearchAction(this, IconSize.MIDDLE);
    private JTextPane textArea;

    public LoggingViewer() {
        this(new JTextPane());
    }

    private LoggingViewer(JTextPane textArea) {
        super(textArea);
        this.textArea = textArea;
        this.textArea.setToolTipText("Displays logging messages according to the current log verbosity (parameter of root operator).");
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(this);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.outputStream = new LoggingViewerOutputStream(this.textArea);
    }

    public Object readResolve() {
        this.outputStream = new LoggingViewerOutputStream(this.textArea);
        return this;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    public void mousePressed(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu().show(this.textArea, e.getX(), e.getY());
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.CLEAR_MESSAGE_VIEWER_ACTION_24);
        menu.add(this.SAVE_LOGFILE_ACTION_24);
        menu.add(this.SEARCH_ACTION_24);
        return menu;
    }

    public String getLogMessage() {
        return this.textArea.getText();
    }

    public void clear() {
        this.outputStream.clear();
        this.textArea.setText("");
    }

    public void saveLog() {
        File file = new File("./");
        String logFile = null;
        try {
            logFile = YaleGUI.getMainFrame().getExperiment().getRootOperator().getParameterAsString("logfile");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (logFile != null) {
            file = YaleGUI.getMainFrame().getExperiment().resolveFileName(logFile);
        } else {
            file = YaleGUI.getMainFrame().getExperiment().getExperimentFile();
            if (file != null) {
                file = file.getParentFile();
            }
        }
        file = SwingTools.chooseFile((Component)this, file, false, "log", "log file");
        if (file != null) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                out.println(this.textArea.getText());
                out.close();
            }
            catch (IOException ex) {
                SwingTools.showErrorMessage("Cannot write log file.", ex);
            }
        }
    }

    public void performSearch() {
        new SearchDialog(this, new SearchableJTextComponent(this.textArea)).setVisible(true);
    }
}

