/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.gui.tools.ColoredTableCellRenderer;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.TableSorter;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ExtendedJTable
extends JTable {
    private static final long serialVersionUID = 4840252601155251257L;
    private boolean sortable = true;
    private transient ColoredTableCellRenderer renderer = new ColoredTableCellRenderer();

    public ExtendedJTable() {
        this(null, true);
    }

    public ExtendedJTable(boolean sortable) {
        this(null, sortable);
    }

    public ExtendedJTable(TableModel model, boolean sortable) {
        this(model, sortable, true);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable) {
        this.sortable = sortable;
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(columnMovable);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (model != null) {
            this.setModel(model);
        }
    }

    public Object readResolve() {
        this.renderer = new ColoredTableCellRenderer();
        return this;
    }

    public Color getCellColor(int row, int column) {
        if (row % 2 == 0) {
            return Color.WHITE;
        }
        return SwingTools.LIGHTEST_BLUE;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setModel(TableModel model) {
        if (this.sortable) {
            TableSorter sorter = new TableSorter(model);
            sorter.setTableHeader(this.getTableHeader());
            super.setModel(sorter);
        } else {
            super.setModel(model);
        }
    }

    public void columnMoved(TableColumnModelEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMoved(e);
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMarginChanged(e);
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        Color color = this.getCellColor(row, col);
        if (color != null) {
            this.renderer.setColor(color);
        }
        return this.renderer;
    }
}

