/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ColoredTableCellRenderer
implements TableCellRenderer {
    private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
    private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Table.textForeground");
    private JTextField renderer = new JTextField();

    public ColoredTableCellRenderer() {
        this.renderer.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setColor(Color color) {
        this.renderer.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            double numberValue = number.doubleValue();
            text = Tools.formatIntegerIfPossible(numberValue);
        } else {
            text = value != null ? value.toString() : "?";
        }
        this.renderer.setText(text);
        if (isSelected) {
            this.renderer.setBackground(SELECTED_COLOR);
            this.renderer.setForeground(TEXT_SELECTED_COLOR);
        } else {
            this.renderer.setForeground(TEXT_NON_SELECTED_COLOR);
        }
        return this.renderer;
    }
}

