/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.tools;

import edu.udo.cs.yale.Version;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;

public class CheckForUpdatesThread
extends Thread {
    private static final String[] VERSION_URLS = new String[]{"http://www-ai.cs.uni-dortmund.de/SOFTWARE/YALE/version.txt", "http://www.rapid-i.com/versions/yale/version.txt"};
    private boolean showFailureDialog = false;
    private MainFrame mainFrame;

    public CheckForUpdatesThread(MainFrame mainFrame, boolean dialog) {
        this.mainFrame = mainFrame;
        this.showFailureDialog = dialog;
    }

    public void run() {
        LinkedList<String> remoteVersions = new LinkedList<String>();
        String[] stringArray = VERSION_URLS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            URL url = null;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e) {
                LogService.logMessage("Cannot create update target url: " + e.getMessage(), 6);
            }
            if (url != null) {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    String remoteVersion = in.readLine();
                    if (remoteVersion != null && remoteVersion.length() > 0 && Character.isDigit(remoteVersion.charAt(0))) {
                        remoteVersions.add(remoteVersion);
                    }
                    in.close();
                }
                catch (IOException e) {
                    LogService.logMessage("Not able to check for updates. Maybe no internet connection.", 4);
                }
            }
            ++n;
        }
        if (remoteVersions.size() > 0) {
            YaleGUI.saveLastUpdateCheckDate();
        }
        Iterator i = remoteVersions.iterator();
        String newestVersion = Version.getVersion();
        while (i.hasNext()) {
            String remoteVersion = (String)i.next();
            if (remoteVersion == null || remoteVersion.compareTo(newestVersion) <= 0) continue;
            newestVersion = remoteVersion;
        }
        if (newestVersion != null && newestVersion.compareTo(Version.getVersion()) > 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "New version of Yale is available:" + Tools.getLineSeparator() + Tools.getLineSeparator() + "          Yale " + newestVersion + Tools.getLineSeparator() + Tools.getLineSeparator() + "Please download it from:" + Tools.getLineSeparator() + "          http://yale.sf.net", "New Yale version", 1);
        } else if (this.showFailureDialog) {
            JOptionPane.showMessageDialog(this.mainFrame, "No newer versions of Yale available!", "Yale is up to date", 1);
        }
    }
}

