/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.templates;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.templates.Template;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsTemplateDialog
extends JDialog {
    private static final long serialVersionUID = -4892200177390173103L;
    private boolean ok = false;
    private JTextField nameField = new JTextField();
    private JTextField descriptionField = new JTextField();
    private TemplateParameterTableModel tableModel = null;

    public SaveAsTemplateDialog(MainFrame mainFrame, Operator operator) {
        super(mainFrame, "Save as Template", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JPanel textPanel = SwingTools.createTextPanel("Save this experiment as Template...", "Please specify a name and short description of this template. The selected parameters can be determined by the user in addition to the mandatory parameters.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        JLabel label = new JLabel("Name");
        label.setToolTipText("The name of the template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.nameField.setToolTipText("The name of the template.");
        c.gridwidth = 0;
        layout.setConstraints(this.nameField, c);
        mainPanel.add(this.nameField);
        label = new JLabel("Description");
        label.setToolTipText("A short description of this template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.descriptionField.setToolTipText("A short description of this template.");
        c.gridwidth = 0;
        layout.setConstraints(this.descriptionField, c);
        mainPanel.add(this.descriptionField);
        sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        this.tableModel = new TemplateParameterTableModel(this.getParameters(operator));
        ExtendedJTable table = new ExtendedJTable((TableModel)this.tableModel, false);
        JScrollPane tablePane = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(new Dimension(600, 200));
        table.getTableHeader().setToolTipText("Select the parameters which could be defined by the user.");
        table.setRowHeight(table.getRowHeight() + 10);
        table.getTableHeader().setReorderingAllowed(false);
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(tablePane, c);
        mainPanel.add(tablePane);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsTemplateDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsTemplateDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(700, 500);
        this.setLocationRelativeTo(mainFrame);
    }

    private OperatorParameterPair[] getParameters(Operator operator) {
        LinkedList<OperatorParameterPair> parameters = new LinkedList<OperatorParameterPair>();
        this.addParameters(operator, parameters);
        Collections.sort(parameters);
        OperatorParameterPair[] result = new OperatorParameterPair[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    private void addParameters(Operator operator, List<OperatorParameterPair> parameters) {
        for (ParameterType type : operator.getParameterTypes()) {
            if (!type.isOptional()) continue;
            parameters.add(new OperatorParameterPair(new String[]{operator.getName(), type.getKey()}));
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int n = 0;
            while (n < chain.getNumberOfOperators()) {
                this.addParameters(chain.getOperator(n), parameters);
                ++n;
            }
        }
    }

    private void addMandatoryParameters(Operator operator, List<String[]> parameters) {
        for (ParameterType type : operator.getParameterTypes()) {
            if (type.isOptional()) continue;
            parameters.add(new String[]{operator.getName(), type.getKey()});
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int n = 0;
            while (n < chain.getNumberOfOperators()) {
                this.addMandatoryParameters(chain.getOperator(n), parameters);
                ++n;
            }
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public Template getTemplate(Operator operator) {
        String name = this.nameField.getText();
        List<String[]> selectedOptional = this.tableModel.getSelectedParameters();
        this.addMandatoryParameters(operator, selectedOptional);
        return new Template(name, this.descriptionField.getText(), String.valueOf(name) + ".xml", selectedOptional);
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a name for this template!");
            return false;
        }
        File[] preDefinedTemplateFiles = ParameterService.getConfigFile("templates").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] userDefinedTemplateFiles = ParameterService.getUserYaleDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        File[] templateFiles = new File[preDefinedTemplateFiles.length + userDefinedTemplateFiles.length];
        System.arraycopy(preDefinedTemplateFiles, 0, templateFiles, 0, preDefinedTemplateFiles.length);
        System.arraycopy(userDefinedTemplateFiles, 0, templateFiles, preDefinedTemplateFiles.length, userDefinedTemplateFiles.length);
        int i = 0;
        while (i < templateFiles.length) {
            String tempName = templateFiles[i].getName().substring(0, templateFiles[i].getName().lastIndexOf("."));
            if (tempName.equals(name)) {
                SwingTools.showVerySimpleErrorMessage("Name '" + name + "' is already used." + Tools.getLineSeparator() + "Please change name or delete the old template!");
                return false;
            }
            ++i;
        }
        return true;
    }

    private void ok() {
        if (this.checkIfNameOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperatorParameterPair
    implements Comparable<OperatorParameterPair> {
        private String[] pair;

        public OperatorParameterPair(String[] pair) {
            this.pair = pair;
        }

        @Override
        public int compareTo(OperatorParameterPair opp) {
            return (String.valueOf(this.pair[0]) + "." + this.pair[1]).compareTo(String.valueOf(opp.pair[0]) + "." + opp.pair[1]);
        }

        public boolean equals(Object o) {
            if (!(o instanceof OperatorParameterPair)) {
                return false;
            }
            return this.pair == ((OperatorParameterPair)o).pair;
        }

        public int hashCode() {
            return this.pair.hashCode();
        }

        public String toString() {
            return String.valueOf(this.pair[0]) + "." + this.pair[1];
        }

        public String[] getStringPair() {
            return this.pair;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateParameterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 394789495217375600L;
        private transient OperatorParameterPair[] parameters;
        private boolean[] selection;

        public TemplateParameterTableModel(OperatorParameterPair[] parameters) {
            this.parameters = parameters;
            this.selection = new boolean[parameters.length];
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Parameter name";
            }
            return "Selected for Template";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.parameters[row].toString();
            }
            return this.selection[row];
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            if (column == 1) {
                this.selection[row] = (Boolean)o;
                this.fireTableCellUpdated(row, column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public int getRowCount() {
            return this.parameters.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public List<String[]> getSelectedParameters() {
            LinkedList<String[]> selected = new LinkedList<String[]>();
            int i = 0;
            while (i < this.parameters.length) {
                if (this.selection[i]) {
                    selected.add(this.parameters[i].getStringPair());
                }
                ++i;
            }
            return selected;
        }
    }
}

