/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.templates;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.templates.BuildingBlock;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.BuildingBlockService;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBuildingBlockMenu
extends JMenu {
    private static final long serialVersionUID = 316102134905132452L;
    private static final String NEW_BUILDING_BLOCK_ICON_NAME = "icons/24/box_new.png";
    private static Icon newBuildingBlockIcon = null;

    static {
        newBuildingBlockIcon = SwingTools.createIcon(NEW_BUILDING_BLOCK_ICON_NAME);
    }

    public NewBuildingBlockMenu() {
        super("New building block");
        this.setIcon(newBuildingBlockIcon);
    }

    public void addAllMenuItems() {
        this.setMenuItems(BuildingBlockService.getBuildingBlocks());
    }

    public void setMenuItems(Collection<BuildingBlock> buildingBlocks) {
        this.removeAll();
        for (final BuildingBlock buildingBlock : buildingBlocks) {
            JMenuItem item = null;
            final String name = buildingBlock.getName();
            String iconPath = buildingBlock.getIconPath();
            if (iconPath == null) {
                item = new JMenuItem(name);
            } else {
                BufferedImage image = null;
                try {
                    URL url = Tools.getResource("icons/" + iconPath);
                    if (url != null) {
                        image = ImageIO.read(url);
                        item = new JMenuItem(name, new ImageIcon(image));
                    } else {
                        item = new JMenuItem(name);
                    }
                }
                catch (IOException e) {
                    LogService.logMessage("Cannot load icon '" + iconPath + "'.", 6);
                    item = new JMenuItem(name);
                }
            }
            item.setToolTipText(buildingBlock.getDescription());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String xmlDescription = buildingBlock.getXML();
                    try {
                        InputSource source = new InputSource(new StringReader(xmlDescription));
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                        Element element = document.getDocumentElement();
                        Operator operator = Operator.createFromXML(element);
                        YaleGUI.getMainFrame().getOperatorTree().insert(operator);
                    }
                    catch (Exception ex) {
                        SwingTools.showErrorMessage("Cannot instantiate building block '" + name + "'.", ex);
                    }
                }
            });
            item.setEnabled(NewBuildingBlockMenu.checkBuildingBlock(buildingBlock));
            this.add(item);
        }
    }

    public static boolean checkBuildingBlock(BuildingBlock buildingBlock) {
        try {
            String xmlDescription = buildingBlock.getXML();
            InputSource source = new InputSource(new StringReader(xmlDescription));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            Element element = document.getDocumentElement();
            Operator operator = Operator.createFromXML(element);
            operator.remove();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (XMLException e) {
            return false;
        }
    }
}

