/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.templates;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.templates.Template;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ManageTemplatesDialog
extends JDialog {
    private static final long serialVersionUID = 1428487062393160289L;
    private JList templateList = new JList();
    private Map<String, Template> templateMap = new HashMap<String, Template>();

    public ManageTemplatesDialog(MainFrame mainFrame) {
        super(mainFrame, "Manage Templates", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel textPanel = SwingTools.createTextPanel("Manage Templates...", "Please select templates to delete them. Only user defined templates can be removed.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        File[] templateFiles = ParameterService.getUserYaleDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        int i = 0;
        while (i < templateFiles.length) {
            try {
                Template template = new Template(templateFiles[i]);
                this.templateMap.put(template.getName(), template);
            }
            catch (Throwable e) {
                SwingTools.showErrorMessage("Cannot load template file '" + templateFiles[i] + "'", e);
            }
            ++i;
        }
        JScrollPane listPane = new JScrollPane(this.templateList);
        c.gridwidth = 0;
        c.weighty = 1.0;
        layout.setConstraints(listPane, c);
        mainPanel.add(listPane);
        c.weighty = 0.0;
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageTemplatesDialog.this.delete();
            }
        });
        buttonPanel.add(deleteButton);
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageTemplatesDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.update();
        this.pack();
        this.setSize(250, 400);
        this.setLocationRelativeTo(mainFrame);
    }

    private void update() {
        Vector<String> data = new Vector<String>();
        for (Template template : this.templateMap.values()) {
            data.add(template.getName());
        }
        this.templateList.setListData(data);
        this.repaint();
    }

    private void ok() {
        this.dispose();
    }

    private void delete() {
        Object[] selection = this.templateList.getSelectedValues();
        int i = 0;
        while (i < selection.length) {
            String name = (String)selection[i];
            Template template = this.templateMap.remove(name);
            File templateFile = template.getFile();
            File expFile = new File(templateFile.getParent(), template.getFilename());
            templateFile.delete();
            expFile.delete();
            ++i;
        }
        this.update();
    }
}

