/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.templates;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.templates.BuildingBlock;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.BuildingBlockService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ManageBuildingBlocksDialog
extends JDialog {
    private static final long serialVersionUID = -2146505003821251075L;
    private JList buildingBlockList = new JList();
    private Map<String, BuildingBlock> buildingBlockMap = new HashMap<String, BuildingBlock>();

    public ManageBuildingBlocksDialog(MainFrame mainFrame) {
        super(mainFrame, "Manage Building Blocks", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel textPanel = SwingTools.createTextPanel("Manage Building Blocks...", "Please select building blocks to delete them. Only user defined building blocks can be removed.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        List<BuildingBlock> buildingBlocks = BuildingBlockService.getUserBuildingBlocks();
        for (BuildingBlock buildingBlock : buildingBlocks) {
            this.buildingBlockMap.put(buildingBlock.getName(), buildingBlock);
        }
        JScrollPane listPane = new JScrollPane(this.buildingBlockList);
        c.gridwidth = 0;
        c.weighty = 1.0;
        layout.setConstraints(listPane, c);
        mainPanel.add(listPane);
        c.weighty = 0.0;
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageBuildingBlocksDialog.this.delete();
            }
        });
        buttonPanel.add(deleteButton);
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageBuildingBlocksDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.update();
        this.pack();
        this.setSize(250, 400);
        this.setLocationRelativeTo(mainFrame);
    }

    private void update() {
        Vector<String> data = new Vector<String>();
        for (BuildingBlock buildingBlock : this.buildingBlockMap.values()) {
            data.add(buildingBlock.getName());
        }
        this.buildingBlockList.setListData(data);
        this.repaint();
    }

    private void ok() {
        this.dispose();
    }

    private void delete() {
        Object[] selection = this.buildingBlockList.getSelectedValues();
        int i = 0;
        while (i < selection.length) {
            String name = (String)selection[i];
            BuildingBlock buildingBlock = this.buildingBlockMap.remove(name);
            File buildingBlockFile = buildingBlock.getFile();
            buildingBlockFile.delete();
            ++i;
        }
        this.update();
    }
}

