/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.properties.SimplePropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WizardPropertyTable
extends SimplePropertyTable {
    private static final long serialVersionUID = 1510360561085238281L;
    private transient Operator[] operators;
    private transient ParameterType[] parameterTypes;

    public WizardPropertyTable() {
        this.setExperiment(null, null);
    }

    public void setExperiment(Experiment experiment, List parameters) {
        if (experiment == null) {
            parameters = new LinkedList();
        }
        this.updateTableData(parameters.size());
        this.operators = new Operator[parameters.size()];
        this.parameterTypes = new ParameterType[parameters.size()];
        Iterator i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] parameter = (String[])i.next();
            this.operators[j] = experiment.getOperator(parameter[0]);
            this.parameterTypes[j] = WizardPropertyTable.getParameterType(this.operators[j], parameter[1]);
            this.getModel().setValueAt(String.valueOf(this.operators[j].getName()) + "." + this.parameterTypes[j].getKey(), j, 0);
            Object value = this.parameterTypes[j].getDefaultValue();
            try {
                value = this.operators[j].getParameters().getParameter(this.parameterTypes[j].getKey());
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            this.getModel().setValueAt(value, j, 1);
            ++j;
        }
        this.updateEditorsAndRenderers();
        this.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                WizardPropertyTable.this.setValue(e.getFirstRow(), WizardPropertyTable.this.getModel().getValueAt(e.getFirstRow(), 1));
            }
        });
    }

    private static ParameterType getParameterType(Operator operator, String key) {
        for (ParameterType type : operator.getParameterTypes()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return null;
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return this.operators[row];
    }
}

