/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.properties.PropertyValueCellEditor;
import edu.udo.cs.yale.gui.properties.TextPropertyDialog;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeText;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class TextValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -4429790999365057931L;
    private ParameterTypeText type;
    private JButton button = new JButton("Edit Text...");
    private String text = null;

    public TextValueCellEditor(ParameterTypeText type) {
        this.type = type;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
    }

    public void setOperator(final Operator operator) {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextPropertyDialog dialog = new TextPropertyDialog(TextValueCellEditor.this.type, TextValueCellEditor.this.text, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    TextValueCellEditor.this.text = dialog.getText();
                    TextValueCellEditor.this.setButtonText();
                    TextValueCellEditor.this.fireEditingStopped();
                } else {
                    TextValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return this.text;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.text = (String)value;
        this.setButtonText();
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        if (this.text != null && this.text.length() > 0) {
            this.button.setText("Edit Text (" + this.text.length() + " characters)...");
        } else {
            this.button.setText("Edit Text...");
        }
    }
}

