/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.syntax.HTMLTokenMarker;
import edu.udo.cs.yale.gui.tools.syntax.JEditTextArea;
import edu.udo.cs.yale.gui.tools.syntax.JavaTokenMarker;
import edu.udo.cs.yale.gui.tools.syntax.TSQLTokenMarker;
import edu.udo.cs.yale.gui.tools.syntax.TextAreaDefaults;
import edu.udo.cs.yale.gui.tools.syntax.TokenMarker;
import edu.udo.cs.yale.gui.tools.syntax.XMLTokenMarker;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeText;
import edu.udo.cs.yale.operator.parameter.TextType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class TextPropertyDialog
extends JDialog {
    private static final long serialVersionUID = 8574310060170861505L;
    private String text = null;
    private boolean ok = false;
    private JEditTextArea textArea = null;

    public TextPropertyDialog(ParameterTypeText type, String text, Operator operator) {
        super(YaleGUI.getMainFrame(), "Text Editor for '" + type.getKey() + "'", true);
        this.text = text;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextPropertyDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextPropertyDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        TextAreaDefaults defaultSettings = TextAreaDefaults.getDefaults();
        defaultSettings.styles = SwingTools.getSyntaxStyles();
        this.textArea = new JEditTextArea(defaultSettings);
        TokenMarker marker = this.createTokenMarker(type.getTextType());
        if (marker != null) {
            this.textArea.setTokenMarker(marker);
        }
        this.textArea.setText(this.text);
        this.getContentPane().add((Component)this.textArea, "Center");
        this.setSize(YaleGUI.getMainFrame().getWidth() / 2, YaleGUI.getMainFrame().getHeight() / 2);
        this.setLocationRelativeTo(YaleGUI.getMainFrame());
    }

    private void ok() {
        this.ok = true;
        this.text = this.textArea.getText();
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getText() {
        return this.text;
    }

    private TokenMarker createTokenMarker(TextType type) {
        switch (type) {
            case PLAIN: {
                return null;
            }
            case XML: {
                return new XMLTokenMarker();
            }
            case HTML: {
                return new HTMLTokenMarker();
            }
            case SQL: {
                return new TSQLTokenMarker();
            }
            case JAVA: {
                return new JavaTokenMarker();
            }
        }
        return null;
    }
}

