/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.properties.PropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = 649188519589057381L;
    private transient ParameterType[] parameterTypes;

    public SettingsPropertyTable() {
        this(Yale.getYaleProperties());
    }

    public SettingsPropertyTable(Collection<ParameterType> allProperties) {
        super(new String[]{"Property", "Value"});
        this.parameterTypes = new ParameterType[allProperties.size()];
        allProperties.toArray(this.parameterTypes);
        this.updateTableData(this.parameterTypes.length);
        int i = 0;
        while (i < this.parameterTypes.length) {
            ParameterType type = this.parameterTypes[i];
            String key = this.parameterTypes[i].getKey();
            this.getModel().setValueAt(key, i, 0);
            Object property = System.getProperty(key);
            property = property == null ? type.getDefaultValue() : type.checkValue(property);
            this.getModel().setValueAt(property, i, 1);
            ++i;
        }
        this.updateEditorsAndRenderers();
    }

    @Override
    public Object readResolve() {
        return this;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    @Override
    public Operator getOperator(int row) {
        return null;
    }

    private String getPropertyValue(int index) {
        Object value = this.getModel().getValueAt(index, 1);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void applyProperties() {
        int i = 0;
        while (i < this.parameterTypes.length) {
            String value = this.getPropertyValue(i);
            if (value != null) {
                System.setProperty(this.parameterTypes[i].getKey(), value);
            }
            ++i;
        }
    }

    public void writeProperties(PrintWriter out) throws IOException {
        int i = 0;
        while (i < this.parameterTypes.length) {
            String key = this.parameterTypes[i].getKey();
            String value = this.getPropertyValue(i);
            if (value != null) {
                System.setProperty(key, value);
                out.println("# " + this.parameterTypes[i].getDescription());
                out.println(String.valueOf(key) + " = " + value);
            }
            ++i;
        }
    }
}

