/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.properties.AttributeFileCellEditor;
import edu.udo.cs.yale.gui.properties.ColorValueCellEditor;
import edu.udo.cs.yale.gui.properties.ConfigurationWizardValueCellEditor;
import edu.udo.cs.yale.gui.properties.DefaultPropertyKeyRenderer;
import edu.udo.cs.yale.gui.properties.DefaultPropertyValueCellEditor;
import edu.udo.cs.yale.gui.properties.InnerOperatorValueCellEditor;
import edu.udo.cs.yale.gui.properties.ListValueCellEditor;
import edu.udo.cs.yale.gui.properties.OperatorValueValueCellEditor;
import edu.udo.cs.yale.gui.properties.ParameterValueKeyCellEditor;
import edu.udo.cs.yale.gui.properties.PreviewValueCellEditor;
import edu.udo.cs.yale.gui.properties.PropertyKeyCellEditor;
import edu.udo.cs.yale.gui.properties.PropertyValueCellEditor;
import edu.udo.cs.yale.gui.properties.SimpleFileValueCellEditor;
import edu.udo.cs.yale.gui.properties.TextValueCellEditor;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.ParameterTypeConfiguration;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInnerOperator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeParameterValue;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypePreview;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeText;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyTable
extends ExtendedJTable {
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>> knownValueEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>>();
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>> knownKeyEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>>();
    private DefaultTableModel model;
    private List<PropertyValueCellEditor> valueEditors = new ArrayList<PropertyValueCellEditor>();
    private List<PropertyKeyCellEditor> keyEditors = new ArrayList<PropertyKeyCellEditor>();
    private List<String> toolTips = new ArrayList<String>();
    private String[] columnNames = new String[]{"Key", "Value"};

    static {
        PropertyTable.registerPropertyValueCellEditor(ParameterTypePassword.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeConfiguration.class, ConfigurationWizardValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypePreview.class, PreviewValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeColor.class, ColorValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeStringCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeBoolean.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeInt.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeDouble.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeAttributeFile.class, AttributeFileCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeFile.class, SimpleFileValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeValue.class, OperatorValueValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeInnerOperator.class, InnerOperatorValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeList.class, ListValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeText.class, TextValueCellEditor.class);
        PropertyTable.registerPropertyKeyCellEditor(ParameterTypeParameterValue.class, ParameterValueKeyCellEditor.class);
    }

    public PropertyTable() {
        this(new String[]{"Key", "Value"});
    }

    public PropertyTable(String[] columnNames) {
        super(null, false, false);
        this.columnNames = columnNames;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(this.getRowHeight() + 10);
    }

    public abstract ParameterType getParameterType(int var1);

    public abstract Operator getOperator(int var1);

    public DefaultTableModel getDefaultModel() {
        return this.model;
    }

    protected void updateEditorsAndRenderers() {
        this.valueEditors.clear();
        this.keyEditors.clear();
        this.toolTips.clear();
        int numberOfRows = this.getModel().getRowCount();
        int i = 0;
        while (i < numberOfRows) {
            String range;
            ParameterType type = this.getParameterType(i);
            this.valueEditors.add(PropertyTable.createPropertyValueCellEditor(type, this.getOperator(i)));
            this.keyEditors.add(PropertyTable.createPropertyKeyCellEditor(type, this.getOperator(i)));
            String toolTip = type.getDescription();
            if (!(type instanceof ParameterTypeCategory) && !(type instanceof ParameterTypeStringCategory) && (range = type.getRange()) != null && range.trim().length() > 0) {
                toolTip = String.valueOf(toolTip) + " (" + type.getRange() + ")";
            }
            this.toolTips.add(SwingTools.transformToolTipText(toolTip));
            ++i;
        }
    }

    protected void updateTableData(int rows) {
        this.model = new DefaultTableModel(this.columnNames, rows);
        this.setModel(this.model);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return this.valueEditors.get(row);
        }
        TableCellRenderer renderer = this.keyEditors.get(row);
        if (renderer instanceof TableCellEditor) {
            return (TableCellEditor)((Object)renderer);
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            PropertyValueCellEditor editor = this.valueEditors.get(row);
            if (!editor.useEditorAsRenderer()) {
                return super.getCellRenderer(row, column);
            }
            return editor;
        }
        return this.keyEditors.get(row);
    }

    private String getToolTipText(int row) {
        if (row >= 0 && row < this.toolTips.size()) {
            return this.toolTips.get(row);
        }
        return "";
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        return this.getToolTipText(row);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = PropertyTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex == 0) {
                    return "The names of the parameters.";
                }
                return "The values of the parameters.";
            }
        };
    }

    public static void registerPropertyValueCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyValueCellEditor> editor) {
        knownValueEditors.put(typeClass, editor);
    }

    public static void registerPropertyKeyCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyKeyCellEditor> editor) {
        knownKeyEditors.put(typeClass, editor);
    }

    private static PropertyValueCellEditor createPropertyValueCellEditor(ParameterType type, Operator operator) {
        Class<? extends PropertyValueCellEditor> clazz = knownValueEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null) {
                if (!ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) break;
                clazz = knownValueEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyValueCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyValueCellEditor editor = constructor.newInstance(type);
                editor.setOperator(operator);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
            editor.setOperator(operator);
            return editor;
        }
        DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
        editor.setOperator(operator);
        return editor;
    }

    private static PropertyKeyCellEditor createPropertyKeyCellEditor(ParameterType type, Operator operator) {
        Class<? extends PropertyKeyCellEditor> clazz = knownKeyEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null) {
                if (!ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) break;
                clazz = knownKeyEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyKeyCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyKeyCellEditor editor = constructor.newInstance(type);
                editor.setOperator(operator);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.logMessage("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
            editor.setOperator(operator);
            return editor;
        }
        DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
        editor.setOperator(operator);
        return editor;
    }
}

